/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.tika.decompress;

import com.typesafe.config.Config;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.mime.MediaType;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.MorphlineRuntimeException;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.shaded.com.google.common.io.Closeables;
import org.kitesdk.morphline.stdio.AbstractParser;
import org.kitesdk.morphline.tika.decompress.EmbeddedExtractor;

public final class UnpackBuilder
implements CommandBuilder {
    public Collection<String> getNames() {
        return Collections.singletonList("unpack");
    }

    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new Unpack(this, config, parent, child, context);
    }

    private static final class Unpack
    extends AbstractParser {
        private static final String GTAR = "application/x-gtar";
        private static final MediaType ZIP = MediaType.APPLICATION_ZIP;
        private static final MediaType JAR = MediaType.application((String)"java-archive");
        private static final MediaType AR = MediaType.application((String)"x-archive");
        private static final MediaType CPIO = MediaType.application((String)"x-cpio");
        private static final MediaType DUMP = MediaType.application((String)"x-tika-unix-dump");
        private static final MediaType TAR = MediaType.application((String)"x-tar");
        private static final Set<MediaType> SUPPORTED_TYPES = MediaType.set((MediaType[])new MediaType[]{ZIP, JAR, AR, CPIO, DUMP, TAR});

        public Unpack(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            if (!config.hasPath("supportedMimeTypes")) {
                for (MediaType mediaType : SUPPORTED_TYPES) {
                    this.addSupportedMimeType(mediaType.toString());
                }
                this.addSupportedMimeType(GTAR);
            }
            this.validateArguments();
        }

        protected boolean doProcess(Record record, InputStream stream) {
            ArchiveInputStream ais;
            EmbeddedExtractor extractor = new EmbeddedExtractor();
            stream = new CloseShieldInputStream(stream);
            stream = new BufferedInputStream(stream);
            try {
                ArchiveStreamFactory factory = new ArchiveStreamFactory();
                ais = factory.createArchiveInputStream(stream);
            }
            catch (ArchiveException e) {
                throw new MorphlineRuntimeException("Unable to unpack document stream", (Throwable)e);
            }
            try {
                ArchiveEntry entry = ais.getNextEntry();
                while (entry != null) {
                    if (!entry.isDirectory() && !this.parseEntry(ais, entry, extractor, record)) {
                        boolean bl = false;
                        return bl;
                    }
                    entry = ais.getNextEntry();
                }
            }
            catch (IOException e) {
                throw new MorphlineRuntimeException((Throwable)e);
            }
            finally {
                Closeables.closeQuietly((Closeable)ais);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean parseEntry(ArchiveInputStream archive, ArchiveEntry entry, EmbeddedExtractor extractor, Record record) {
            String name = entry.getName();
            if (archive.canReadEntryData(entry)) {
                Record entrydata = new Record();
                TemporaryResources tmp = new TemporaryResources();
                try {
                    TikaInputStream tis = TikaInputStream.get((InputStream)archive, (TemporaryResources)tmp);
                    boolean bl = extractor.parseEmbedded((InputStream)tis, entrydata, name, this.getChild());
                    return bl;
                }
                finally {
                    try {
                        tmp.dispose();
                    }
                    catch (TikaException e) {
                        this.LOG.warn("Cannot dispose of tmp Tika resources", (Throwable)e);
                    }
                }
            }
            return false;
        }
    }
}

