/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.ClientSessionOptions;
import com.mongodb.MongoInternalException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.TransactionOptions;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.ClientSession;
import com.mongodb.async.client.MongoClient;
import com.mongodb.async.client.OperationExecutor;
import com.mongodb.internal.session.BaseClientSessionImpl;
import com.mongodb.internal.session.ServerSessionPool;
import com.mongodb.operation.AbortTransactionOperation;
import com.mongodb.operation.CommitTransactionOperation;

class ClientSessionImpl
extends BaseClientSessionImpl
implements ClientSession {
    private final OperationExecutor executor;
    private boolean inTransaction;
    private boolean messageSent;
    private TransactionOptions transactionOptions;

    ClientSessionImpl(ServerSessionPool serverSessionPool, MongoClient mongoClient, ClientSessionOptions options, OperationExecutor executor) {
        super(serverSessionPool, (Object)mongoClient, options);
        this.executor = executor;
    }

    @Override
    public boolean hasActiveTransaction() {
        return this.inTransaction;
    }

    @Override
    public boolean notifyMessageSent() {
        boolean firstMessage = !this.messageSent;
        this.messageSent = true;
        return firstMessage;
    }

    @Override
    public TransactionOptions getTransactionOptions() {
        Assertions.isTrue((String)"in transaction", (boolean)this.inTransaction);
        return this.transactionOptions;
    }

    @Override
    public void startTransaction() {
        this.startTransaction(TransactionOptions.builder().build());
    }

    @Override
    public void startTransaction(TransactionOptions transactionOptions) {
        Assertions.notNull((String)"transactionOptions", (Object)transactionOptions);
        if (this.inTransaction) {
            throw new IllegalStateException("Transaction already in progress");
        }
        this.inTransaction = true;
        this.transactionOptions = TransactionOptions.merge((TransactionOptions)transactionOptions, (TransactionOptions)this.getOptions().getDefaultTransactionOptions());
    }

    @Override
    public void commitTransaction(final SingleResultCallback<Void> callback) {
        if (!this.canCommitOrAbort()) {
            throw new IllegalStateException("There is no transaction started");
        }
        if (!this.messageSent) {
            this.cleanupTransaction();
            callback.onResult(null, null);
        } else {
            ReadConcern readConcern = this.transactionOptions.getReadConcern();
            if (readConcern == null) {
                throw new MongoInternalException("Invariant violated.  Transaction options read concern can not be null");
            }
            this.executor.execute(new CommitTransactionOperation(this.transactionOptions.getWriteConcern()), ReadPreference.primary(), readConcern, this, new SingleResultCallback<Void>(){

                public void onResult(Void result, Throwable t) {
                    ClientSessionImpl.this.cleanupTransaction();
                    callback.onResult((Object)result, t);
                }
            });
        }
    }

    @Override
    public void abortTransaction(final SingleResultCallback<Void> callback) {
        if (!this.canCommitOrAbort()) {
            throw new IllegalStateException("There is no transaction started");
        }
        if (!this.messageSent) {
            this.cleanupTransaction();
            callback.onResult(null, null);
        } else {
            ReadConcern readConcern = this.transactionOptions.getReadConcern();
            if (readConcern == null) {
                throw new MongoInternalException("Invariant violated.  Transaction options read concern can not be null");
            }
            this.executor.execute(new AbortTransactionOperation(this.transactionOptions.getWriteConcern()), ReadPreference.primary(), readConcern, this, new SingleResultCallback<Void>(){

                public void onResult(Void result, Throwable t) {
                    ClientSessionImpl.this.cleanupTransaction();
                    callback.onResult(null, null);
                }
            });
        }
    }

    private boolean canCommitOrAbort() {
        return this.inTransaction || this.getOptions().getAutoStartTransaction();
    }

    public void close() {
        if (this.inTransaction) {
            this.abortTransaction(new SingleResultCallback<Void>(){

                public void onResult(Void result, Throwable t) {
                    ClientSessionImpl.super.close();
                }
            });
        } else {
            super.close();
        }
    }

    private void cleanupTransaction() {
        this.inTransaction = false;
        this.messageSent = false;
        this.transactionOptions = null;
        this.getServerSession().advanceTransactionNumber();
    }
}

