/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.ClientSession;
import com.mongodb.async.client.ListCollectionsIterable;
import com.mongodb.async.client.MongoCollection;
import com.mongodb.async.client.MongoIterable;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.CreateViewOptions;
import java.util.List;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

@ThreadSafe
public interface MongoDatabase {
    public String getName();

    public CodecRegistry getCodecRegistry();

    public ReadPreference getReadPreference();

    public WriteConcern getWriteConcern();

    public ReadConcern getReadConcern();

    public MongoDatabase withCodecRegistry(CodecRegistry var1);

    public MongoDatabase withReadPreference(ReadPreference var1);

    public MongoDatabase withWriteConcern(WriteConcern var1);

    public MongoDatabase withReadConcern(ReadConcern var1);

    public MongoCollection<Document> getCollection(String var1);

    public <TDocument> MongoCollection<TDocument> getCollection(String var1, Class<TDocument> var2);

    public void runCommand(Bson var1, SingleResultCallback<Document> var2);

    public void runCommand(Bson var1, ReadPreference var2, SingleResultCallback<Document> var3);

    public <TResult> void runCommand(Bson var1, Class<TResult> var2, SingleResultCallback<TResult> var3);

    public <TResult> void runCommand(Bson var1, ReadPreference var2, Class<TResult> var3, SingleResultCallback<TResult> var4);

    public void runCommand(ClientSession var1, Bson var2, SingleResultCallback<Document> var3);

    public void runCommand(ClientSession var1, Bson var2, ReadPreference var3, SingleResultCallback<Document> var4);

    public <TResult> void runCommand(ClientSession var1, Bson var2, Class<TResult> var3, SingleResultCallback<TResult> var4);

    public <TResult> void runCommand(ClientSession var1, Bson var2, ReadPreference var3, Class<TResult> var4, SingleResultCallback<TResult> var5);

    public void drop(SingleResultCallback<Void> var1);

    public void drop(ClientSession var1, SingleResultCallback<Void> var2);

    public MongoIterable<String> listCollectionNames();

    public MongoIterable<String> listCollectionNames(ClientSession var1);

    public ListCollectionsIterable<Document> listCollections();

    public <TResult> ListCollectionsIterable<TResult> listCollections(Class<TResult> var1);

    public ListCollectionsIterable<Document> listCollections(ClientSession var1);

    public <TResult> ListCollectionsIterable<TResult> listCollections(ClientSession var1, Class<TResult> var2);

    public void createCollection(String var1, SingleResultCallback<Void> var2);

    public void createCollection(String var1, CreateCollectionOptions var2, SingleResultCallback<Void> var3);

    public void createCollection(ClientSession var1, String var2, SingleResultCallback<Void> var3);

    public void createCollection(ClientSession var1, String var2, CreateCollectionOptions var3, SingleResultCallback<Void> var4);

    public void createView(String var1, String var2, List<? extends Bson> var3, SingleResultCallback<Void> var4);

    public void createView(String var1, String var2, List<? extends Bson> var3, CreateViewOptions var4, SingleResultCallback<Void> var5);

    public void createView(ClientSession var1, String var2, String var3, List<? extends Bson> var4, SingleResultCallback<Void> var5);

    public void createView(ClientSession var1, String var2, String var3, List<? extends Bson> var4, CreateViewOptions var5, SingleResultCallback<Void> var6);
}

