/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.annotation;

import java.util.HashMap;
import javax.servlet.ServletException;
import org.mortbay.jetty.plus.annotation.RunAs;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.log.Log;

public class RunAsCollection {
    private HashMap _runAsMap = new HashMap();

    public void add(RunAs runAs) {
        if (runAs == null || runAs.getTargetClass() == null) {
            return;
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Adding run-as for class=" + runAs.getTargetClass()));
        }
        this._runAsMap.put(runAs.getTargetClass().getName(), runAs);
    }

    public RunAs getRunAs(Object o) throws ServletException {
        if (o == null) {
            return null;
        }
        if (!(o instanceof ServletHolder)) {
            return null;
        }
        ServletHolder holder = (ServletHolder)o;
        String className = RunAs.getServletClassNameForHolder(holder);
        return (RunAs)this._runAsMap.get(className);
    }

    public void setRunAs(Object o) throws ServletException {
        if (o == null) {
            return;
        }
        if (!(o instanceof ServletHolder)) {
            return;
        }
        ServletHolder holder = (ServletHolder)o;
        String className = RunAs.getServletClassNameForHolder(holder);
        RunAs runAs = (RunAs)this._runAsMap.get(className);
        if (runAs == null) {
            return;
        }
        runAs.setRunAs(holder);
    }
}

