/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.formats.JsonFormat;
import org.neo4j.service.Services;

@Provider
@Produces(value={"application/json"})
public class RepresentationBasedMessageBodyWriter
implements MessageBodyWriter<Representation> {
    private static final JsonFormat JSON_FORMAT = Services.loadAll(RepresentationFormat.class).stream().filter(JsonFormat.class::isInstance).map(JsonFormat.class::cast).findFirst().orElseThrow(() -> new RuntimeException("Could not load JsonFormat"));
    @Context
    private UriInfo uriInfo;

    public RepresentationBasedMessageBodyWriter() {
    }

    public RepresentationBasedMessageBodyWriter(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public static String serialize(Representation representation, RepresentationFormat format, URI baseUri) {
        return representation.serialize(format, baseUri);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Representation.class.isAssignableFrom(type);
    }

    public void writeTo(Representation representation, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        String content = RepresentationBasedMessageBodyWriter.serialize(representation, JSON_FORMAT, this.uriInfo.getBaseUri());
        entityStream.write(content.getBytes(mediaType.getParameters().getOrDefault("charset", StandardCharsets.UTF_8.name())));
        entityStream.flush();
    }
}

