/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.util.AttributeKey;
import org.neo4j.driver.internal.util.ServerVersion;

public final class ChannelAttributes {
    private static final AttributeKey<BoltServerAddress> ADDRESS = AttributeKey.newInstance("serverAddress");
    private static final AttributeKey<ServerVersion> SERVER_VERSION = AttributeKey.newInstance("serverVersion");
    private static final AttributeKey<Long> CREATION_TIMESTAMP = AttributeKey.newInstance("creationTimestamp");
    private static final AttributeKey<Long> LAST_USED_TIMESTAMP = AttributeKey.newInstance("lastUsedTimestamp");
    private static final AttributeKey<InboundMessageDispatcher> MESSAGE_DISPATCHER = AttributeKey.newInstance("messageDispatcher");
    private static final AttributeKey<String> TERMINATION_REASON = AttributeKey.newInstance("terminationReason");

    private ChannelAttributes() {
    }

    public static BoltServerAddress serverAddress(Channel channel) {
        return ChannelAttributes.get(channel, ADDRESS);
    }

    public static void setServerAddress(Channel channel, BoltServerAddress address) {
        ChannelAttributes.setOnce(channel, ADDRESS, address);
    }

    public static ServerVersion serverVersion(Channel channel) {
        return ChannelAttributes.get(channel, SERVER_VERSION);
    }

    public static void setServerVersion(Channel channel, ServerVersion version) {
        ChannelAttributes.setOnce(channel, SERVER_VERSION, version);
    }

    public static long creationTimestamp(Channel channel) {
        return ChannelAttributes.get(channel, CREATION_TIMESTAMP);
    }

    public static void setCreationTimestamp(Channel channel, long creationTimestamp) {
        ChannelAttributes.setOnce(channel, CREATION_TIMESTAMP, creationTimestamp);
    }

    public static Long lastUsedTimestamp(Channel channel) {
        return ChannelAttributes.get(channel, LAST_USED_TIMESTAMP);
    }

    public static void setLastUsedTimestamp(Channel channel, long lastUsedTimestamp) {
        ChannelAttributes.set(channel, LAST_USED_TIMESTAMP, lastUsedTimestamp);
    }

    public static InboundMessageDispatcher messageDispatcher(Channel channel) {
        return ChannelAttributes.get(channel, MESSAGE_DISPATCHER);
    }

    public static void setMessageDispatcher(Channel channel, InboundMessageDispatcher messageDispatcher) {
        ChannelAttributes.setOnce(channel, MESSAGE_DISPATCHER, messageDispatcher);
    }

    public static String terminationReason(Channel channel) {
        return ChannelAttributes.get(channel, TERMINATION_REASON);
    }

    public static void setTerminationReason(Channel channel, String reason) {
        ChannelAttributes.setOnce(channel, TERMINATION_REASON, reason);
    }

    private static <T> T get(Channel channel, AttributeKey<T> key) {
        return channel.attr(key).get();
    }

    private static <T> void set(Channel channel, AttributeKey<T> key, T value) {
        channel.attr(key).set(value);
    }

    private static <T> void setOnce(Channel channel, AttributeKey<T> key, T value) {
        T existingValue = channel.attr(key).setIfAbsent(value);
        if (existingValue != null) {
            throw new IllegalStateException("Unable to set " + key.name() + " because it is already set to " + existingValue);
        }
    }
}

