/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.inbound;

import org.neo4j.driver.internal.logging.ChannelActivityLogger;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufUtil;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Logging;

public class ChunkDecoder
extends LengthFieldBasedFrameDecoder {
    private static final int MAX_FRAME_BODY_LENGTH = 65535;
    private static final int LENGTH_FIELD_OFFSET = 0;
    private static final int LENGTH_FIELD_LENGTH = 2;
    private static final int LENGTH_ADJUSTMENT = 0;
    private static final int INITIAL_BYTES_TO_STRIP = 2;
    private static final int MAX_FRAME_LENGTH = 65537;
    private final Logging logging;
    private Logger log;

    public ChunkDecoder(Logging logging) {
        super(65537, 0, 2, 0, 2);
        this.logging = logging;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        this.log = new ChannelActivityLogger(ctx.channel(), this.logging, this.getClass());
    }

    @Override
    protected void handlerRemoved0(ChannelHandlerContext ctx) {
        this.log = null;
    }

    @Override
    protected ByteBuf extractFrame(ChannelHandlerContext ctx, ByteBuf buffer, int index, int length) {
        if (this.log.isTraceEnabled()) {
            int originalReaderIndex = buffer.readerIndex();
            int readerIndexWithChunkHeader = originalReaderIndex - 2;
            int lengthWithChunkHeader = 2 + buffer.readableBytes();
            String hexDump = ByteBufUtil.hexDump(buffer, readerIndexWithChunkHeader, lengthWithChunkHeader);
            this.log.trace("S: %s", hexDump);
        }
        return super.extractFrame(ctx, buffer, index, length);
    }
}

