/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime;

import java.util.UUID;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.kernel.api.exceptions.Status;

public class Neo4jError {
    private final Status status;
    private final String message;
    private final Throwable cause;
    private final UUID reference;
    private final boolean fatal;

    private Neo4jError(Status status, String message, Throwable cause, boolean fatal) {
        this.status = status;
        this.message = message;
        this.cause = cause;
        this.fatal = fatal;
        this.reference = UUID.randomUUID();
    }

    private Neo4jError(Status status, String message, boolean fatal) {
        this(status, message, null, fatal);
    }

    private Neo4jError(Status status, Throwable cause, boolean fatal) {
        this(status, status.code().description(), cause, fatal);
    }

    public Status status() {
        return this.status;
    }

    public String message() {
        return this.message;
    }

    public Throwable cause() {
        return this.cause;
    }

    public UUID reference() {
        return this.reference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Neo4jError that = (Neo4jError)o;
        return (this.status != null ? this.status.equals(that.status) : that.status == null) && !(this.message == null ? that.message != null : !this.message.equals(that.message));
    }

    public int hashCode() {
        int result = this.status != null ? this.status.hashCode() : 0;
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Neo4jError{status=" + this.status + ", message='" + this.message + '\'' + ", cause=" + this.cause + ", reference=" + this.reference + '}';
    }

    public static Status codeFromString(String codeStr) {
        String[] parts = codeStr.split("\\.");
        if (parts.length != 4) {
            return Status.General.UnknownError;
        }
        String category = parts[2];
        String error = parts[3];
        switch (category) {
            case "Schema": {
                return Status.Schema.valueOf((String)error);
            }
            case "LegacyIndex": {
                return Status.LegacyIndex.valueOf((String)error);
            }
            case "General": {
                return Status.General.valueOf((String)error);
            }
            case "Statement": {
                return Status.Statement.valueOf((String)error);
            }
            case "Transaction": {
                return Status.Transaction.valueOf((String)error);
            }
            case "Request": {
                return Status.Request.valueOf((String)error);
            }
            case "Network": {
                return Status.Network.valueOf((String)error);
            }
            case "Security": {
                return Status.Security.valueOf((String)error);
            }
        }
        return Status.General.UnknownError;
    }

    private static Neo4jError fromThrowable(Throwable any, boolean isFatal) {
        for (Throwable cause = any; cause != null; cause = cause.getCause()) {
            if (cause instanceof DatabaseShutdownException) {
                return new Neo4jError((Status)Status.General.DatabaseUnavailable, cause, isFatal);
            }
            if (cause instanceof Status.HasStatus) {
                return new Neo4jError(((Status.HasStatus)cause).status(), any.getMessage(), any, isFatal);
            }
            if (cause instanceof OutOfMemoryError) {
                return new Neo4jError((Status)Status.General.OutOfMemoryError, cause, isFatal);
            }
            if (!(cause instanceof StackOverflowError)) continue;
            return new Neo4jError((Status)Status.General.StackOverFlowError, cause, isFatal);
        }
        return new Neo4jError((Status)Status.General.UnknownError, any != null ? any.getMessage() : null, any, isFatal);
    }

    public static Neo4jError from(Status status, String message) {
        return new Neo4jError(status, message, false);
    }

    public static Neo4jError from(Throwable any) {
        return Neo4jError.fromThrowable(any, false);
    }

    public static Neo4jError fatalFrom(Throwable any) {
        return Neo4jError.fromThrowable(any, true);
    }

    public static Neo4jError fatalFrom(Status status, String message) {
        return new Neo4jError(status, message, true);
    }

    public boolean isFatal() {
        return this.fatal;
    }
}

