/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector.listener;

import org.neo4j.bolt.protocol.common.BoltProtocol;
import org.neo4j.bolt.protocol.common.connection.BoltConnectionMetricsMonitor;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.connector.connection.listener.ConnectionListener;
import org.neo4j.bolt.protocol.common.connector.listener.ConnectorListener;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;

public class MetricsConnectorListener
implements ConnectorListener,
ConnectionListener {
    private final BoltConnectionMetricsMonitor monitor;

    public MetricsConnectorListener(BoltConnectionMetricsMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public void onListenerAdded() {
    }

    @Override
    public void onListenerRemoved() {
    }

    @Override
    public void onConnectionCreated(Connection connection) {
        connection.registerListener(this);
    }

    @Override
    public void onProtocolSelected(BoltProtocol protocol) {
        this.monitor.connectionOpened();
    }

    @Override
    public void onActivated() {
        this.monitor.connectionActivated();
    }

    @Override
    public void onIdle() {
        this.monitor.connectionWaiting();
    }

    @Override
    public void onRequestReceived(RequestMessage message) {
        this.monitor.messageReceived();
    }

    @Override
    public void onRequestBeginProcessing(RequestMessage message, long queuedForMillis) {
        this.monitor.messageProcessingStarted(queuedForMillis);
    }

    @Override
    public void onRequestCompletedProcessing(RequestMessage message, long processedForMillis) {
        this.monitor.messageProcessingCompleted(processedForMillis);
    }

    @Override
    public void onRequestFailedProcessing(RequestMessage message, Throwable cause) {
        this.monitor.messageProcessingFailed();
    }

    @Override
    public void onClosed() {
        this.monitor.connectionClosed();
    }
}

