/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.handler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import org.neo4j.bolt.protocol.common.error.AccumulatorResetException;
import org.neo4j.bolt.protocol.common.signal.MessageSignal;
import org.neo4j.packstream.signal.FrameSignal;

public class RecordResponseAccumulator
extends ChannelOutboundHandlerAdapter {
    private CompositeByteBuf pendingChunk;
    private ChannelPromise pendingPromise;

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg == MessageSignal.RESET) {
            if (this.pendingPromise != null) {
                this.pendingPromise.setFailure((Throwable)new AccumulatorResetException());
                this.pendingPromise = null;
            }
            if (this.pendingChunk != null) {
                this.pendingChunk.release();
                this.pendingChunk = null;
            }
            return;
        }
        if (msg == MessageSignal.END) {
            if (this.pendingChunk == null) {
                return;
            }
            ctx.write((Object)this.pendingChunk, this.pendingPromise);
            ctx.writeAndFlush((Object)FrameSignal.MESSAGE_END);
            this.pendingChunk = null;
            this.pendingPromise = null;
            return;
        }
        if (!(msg instanceof ByteBuf)) {
            ctx.write(msg, promise);
            return;
        }
        ByteBuf buf = (ByteBuf)msg;
        if (this.pendingChunk == null) {
            this.pendingChunk = ctx.alloc().compositeBuffer().addComponent(true, buf);
            this.pendingPromise = promise;
        } else {
            this.pendingChunk.addComponent(true, buf);
            this.pendingPromise = RecordResponseAccumulator.attachPromise(this.pendingPromise, promise);
        }
    }

    private static ChannelPromise attachPromise(ChannelPromise original, ChannelPromise attachment) {
        if (original == null) {
            return attachment;
        }
        return original.addListener(f -> {
            if (f.isSuccess()) {
                attachment.setSuccess();
            } else {
                attachment.setFailure(f.cause());
            }
        });
    }
}

