/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import java.util.List;
import org.neo4j.bolt.negotiation.codec.ProtocolNegotiationRequestDecoder;
import org.neo4j.bolt.negotiation.codec.ProtocolNegotiationResponseEncoder;
import org.neo4j.bolt.protocol.common.connector.Connector;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.handler.DiscoveryResponseHandler;
import org.neo4j.bolt.protocol.common.handler.ProtocolHandshakeHandler;
import org.neo4j.bolt.protocol.common.handler.ProtocolLoggingHandler;
import org.neo4j.configuration.Config;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.packstream.codec.transport.WebSocketFramePackingEncoder;
import org.neo4j.packstream.codec.transport.WebSocketFrameUnpackingDecoder;
import org.neo4j.util.VisibleForTesting;

public class TransportSelectionHandler
extends ByteToMessageDecoder {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(TransportSelectionHandler.class);
    public static final long SSL_HANDLER_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(SslHandler.class);
    public static final long HTTP_SERVER_CODEC_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(HttpServerCodec.class);
    public static final long HTTP_OBJECT_AGGREGATOR_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(HttpObjectAggregator.class);
    public static final long WEB_SOCKET_SERVER_PROTOCOL_HANDLER_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(WebSocketServerProtocolHandler.class);
    public static final long WEB_SOCKET_FRAME_AGGREGATOR_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(WebSocketFrameAggregator.class);
    private static final String WEBSOCKET_MAGIC = "GET ";
    private static final int MAX_WEBSOCKET_HANDSHAKE_SIZE = 65536;
    private static final int MAX_WEBSOCKET_FRAME_SIZE = 65536;
    private final Config config;
    private final SslContext sslContext;
    private final InternalLogProvider logging;
    private final InternalLog log;
    private final boolean isEncrypted;
    private Connector connector;
    private Connection connection;

    @VisibleForTesting
    TransportSelectionHandler(Config config, SslContext sslContext, InternalLogProvider logging, boolean isEncrypted) {
        this.config = config;
        this.sslContext = sslContext;
        this.logging = logging;
        this.isEncrypted = isEncrypted;
        this.log = logging.getLog(TransportSelectionHandler.class);
    }

    public TransportSelectionHandler(Config config, SslContext sslContext, InternalLogProvider logging) {
        this(config, sslContext, logging, false);
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.connection = Connection.getConnection(ctx.channel());
        this.connector = this.connection.connector();
    }

    protected void handlerRemoved0(ChannelHandlerContext ctx) {
        this.connection.memoryTracker().releaseHeap(SHALLOW_SIZE);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        if (in.readableBytes() < 5) {
            return;
        }
        if (this.detectSsl(in)) {
            if (this.isEncrypted) {
                this.log.error("Fatal error: multiple levels of SSL encryption detected. Terminating connection: %s", new Object[]{ctx.channel()});
                ctx.close();
                return;
            }
            this.enableSsl(ctx);
        } else if (TransportSelectionHandler.isHttp(in)) {
            this.switchToWebsocket(ctx);
        } else if (TransportSelectionHandler.isBoltPreamble(in)) {
            this.switchToSocket(ctx);
        } else {
            in.clear();
            ctx.close();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        try {
            if (Exceptions.contains((Throwable)cause, e -> e.getMessage().contains("Connection reset by peer"))) {
                this.log.warn("Fatal error occurred when initialising pipeline, remote peer unexpectedly closed connection: %s", new Object[]{ctx.channel()});
            } else {
                this.log.error("Fatal error occurred when initialising pipeline: " + ctx.channel(), cause);
            }
        }
        finally {
            ctx.close();
        }
    }

    private static boolean isBoltPreamble(ByteBuf in) {
        return in.getInt(0) == 1616949271;
    }

    private boolean detectSsl(ByteBuf buf) {
        return this.sslContext != null && SslHandler.isEncrypted((ByteBuf)buf);
    }

    private static boolean isHttp(ByteBuf buf) {
        for (int i = 0; i < WEBSOCKET_MAGIC.length(); ++i) {
            if (buf.getUnsignedByte(buf.readerIndex() + i) == WEBSOCKET_MAGIC.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private void enableSsl(ChannelHandlerContext ctx) {
        this.connection.memoryTracker().allocateHeap(SSL_HANDLER_SHALLOW_SIZE + SHALLOW_SIZE);
        ctx.pipeline().addLast(new ChannelHandler[]{this.sslContext.newHandler(ctx.alloc())}).remove((ChannelHandler)this).addLast(new ChannelHandler[]{new TransportSelectionHandler(this.config, this.sslContext, this.logging, true)});
    }

    private void switchToSocket(ChannelHandlerContext ctx) {
        if (this.connector.isEncryptionRequired() && !this.isEncrypted) {
            throw new SecurityException("An unencrypted connection attempt was made where encryption is required.");
        }
        this.switchToHandshake(ctx);
    }

    private void switchToWebsocket(ChannelHandlerContext ctx) {
        ChannelPipeline p = ctx.pipeline();
        this.connection.memoryTracker().allocateHeap(HTTP_SERVER_CODEC_SHALLOW_SIZE + HTTP_OBJECT_AGGREGATOR_SHALLOW_SIZE + DiscoveryResponseHandler.SHALLOW_SIZE + WEB_SOCKET_SERVER_PROTOCOL_HANDLER_SHALLOW_SIZE + WEB_SOCKET_FRAME_AGGREGATOR_SHALLOW_SIZE + WebSocketFramePackingEncoder.SHALLOW_SIZE + WebSocketFrameUnpackingDecoder.SHALLOW_SIZE);
        p.addLast(new ChannelHandler[]{new HttpServerCodec(), new HttpObjectAggregator(65536), new DiscoveryResponseHandler(this.connector.authConfigProvider()), new WebSocketServerProtocolHandler("/", null, false, 65536), new WebSocketFrameAggregator(65536), new WebSocketFramePackingEncoder(), new WebSocketFrameUnpackingDecoder()});
        this.switchToHandshake(ctx);
    }

    private void switchToHandshake(ChannelHandlerContext ctx) {
        this.connection.memoryTracker().allocateHeap(ProtocolNegotiationResponseEncoder.SHALLOW_SIZE + ProtocolNegotiationRequestDecoder.SHALLOW_SIZE + ProtocolHandshakeHandler.SHALLOW_SIZE);
        ctx.pipeline().addLast("protocolNegotiationRequestEncoder", (ChannelHandler)new ProtocolNegotiationResponseEncoder()).addLast("protocolNegotiationRequestDecoder", (ChannelHandler)new ProtocolNegotiationRequestDecoder());
        ProtocolLoggingHandler.shiftToEndIfPresent(ctx);
        ctx.pipeline().addLast("protocolHandshakeHandler", (ChannelHandler)new ProtocolHandshakeHandler(this.config, this.logging));
        ctx.pipeline().remove((ChannelHandler)this);
    }
}

