/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.io.reader;

import org.neo4j.bolt.protocol.io.StructType;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.error.struct.IllegalStructArgumentException;
import org.neo4j.packstream.error.struct.IllegalStructSizeException;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.packstream.struct.StructReader;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Values;

public final class Point2dReader<CTX>
implements StructReader<CTX, PointValue> {
    private static final Point2dReader<?> INSTANCE = new Point2dReader();

    private Point2dReader() {
    }

    public static <CTX> Point2dReader<CTX> getInstance() {
        return INSTANCE;
    }

    @Override
    public short getTag() {
        return StructType.POINT_2D.getTag();
    }

    @Override
    public PointValue read(CTX ctx, PackstreamBuf buffer, StructHeader header) throws PackstreamReaderException {
        CoordinateReferenceSystem crs;
        if (header.length() != 3L) {
            throw new IllegalStructSizeException(3L, header.length());
        }
        long crsCode = buffer.readInt();
        double x = buffer.readFloat();
        double y = buffer.readFloat();
        if (crsCode > Integer.MAX_VALUE || crsCode < Integer.MIN_VALUE) {
            throw new IllegalStructArgumentException("crs", "crs code exceeds valid bounds");
        }
        try {
            crs = CoordinateReferenceSystem.get((int)((int)crsCode));
        }
        catch (InvalidArgumentException ex) {
            throw new IllegalStructArgumentException("crs", String.format("Illegal coordinate reference system: \"%s\"", crsCode), ex);
        }
        try {
            return Values.pointValue((CoordinateReferenceSystem)crs, (double[])new double[]{x, y});
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalStructArgumentException("coords", String.format("Illegal CRS/coords combination (crs=%s, x=%s, y=%s)", crs, x, y), ex);
        }
    }
}

