/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v40.fsm;

import org.neo4j.bolt.protocol.common.bookmark.Bookmark;
import org.neo4j.bolt.protocol.common.fsm.State;
import org.neo4j.bolt.protocol.common.fsm.StateMachineContext;
import org.neo4j.bolt.protocol.common.message.result.ResultConsumer;
import org.neo4j.bolt.protocol.v40.fsm.AbstractStreamingState;
import org.neo4j.memory.HeapEstimator;

public class AutoCommitState
extends AbstractStreamingState {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(AutoCommitState.class);

    @Override
    public String name() {
        return "AUTOCOMMIT";
    }

    @Override
    protected State processStreamPullResultMessage(int statementId, ResultConsumer resultConsumer, StateMachineContext context, long noToPull) throws Throwable {
        Bookmark bookmark = context.transactionManager().pullData(context.connectionState().getCurrentTransactionId(), statementId, noToPull, resultConsumer);
        bookmark.attachTo(context.connectionState());
        if (resultConsumer.hasMore()) {
            return this;
        }
        return this.readyState;
    }

    @Override
    protected State processStreamDiscardResultMessage(int statementId, ResultConsumer resultConsumer, StateMachineContext context, long noToDiscard) throws Throwable {
        Bookmark bookmark = context.transactionManager().discardData(context.connectionState().getCurrentTransactionId(), statementId, noToDiscard, resultConsumer);
        bookmark.attachTo(context.connectionState());
        if (resultConsumer.hasMore()) {
            return this;
        }
        return this.readyState;
    }
}

