/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v40.fsm;

import org.neo4j.bolt.protocol.common.fsm.State;
import org.neo4j.bolt.protocol.common.fsm.StateMachineContext;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.common.message.request.Signal;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.graphdb.security.AuthorizationExpiredException;
import org.neo4j.util.Preconditions;

public abstract class FailSafeState
implements State {
    protected State failedState;
    private State interruptedState;

    @Override
    public State process(RequestMessage message, StateMachineContext context) throws BoltConnectionFatality {
        this.assertInitialized();
        if (message == Signal.INTERRUPT) {
            return this.interruptedState;
        }
        try {
            return this.processUnsafe(message, context);
        }
        catch (AuthorizationExpiredException e) {
            context.handleFailure(e, true);
            return this.failedState;
        }
        catch (Throwable t) {
            context.handleFailure(t, false);
            return this.failedState;
        }
    }

    public void setFailedState(State failedState) {
        this.failedState = failedState;
    }

    public void setInterruptedState(State interruptedState) {
        this.interruptedState = interruptedState;
    }

    protected void assertInitialized() {
        Preconditions.checkState((this.failedState != null ? 1 : 0) != 0, (String)"Failed state not set");
        Preconditions.checkState((this.interruptedState != null ? 1 : 0) != 0, (String)"Interrupted state not set");
    }

    protected abstract State processUnsafe(RequestMessage var1, StateMachineContext var2) throws Throwable;
}

