/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v40.fsm;

import java.util.UUID;
import org.neo4j.bolt.protocol.common.fsm.State;
import org.neo4j.bolt.protocol.common.fsm.StateMachineContext;
import org.neo4j.bolt.protocol.common.message.AccessMode;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.common.signal.StateSignal;
import org.neo4j.bolt.protocol.v40.fsm.FailSafeState;
import org.neo4j.bolt.protocol.v40.messaging.request.BeginMessage;
import org.neo4j.bolt.protocol.v40.messaging.request.RunMessage;
import org.neo4j.bolt.transaction.ProgramResultReference;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.util.Preconditions;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;

public class ReadyState
extends FailSafeState {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ReadyState.class);
    public static final String FIELDS_KEY = "fields";
    public static final String FIRST_RECORD_AVAILABLE_KEY = "t_first";
    protected State streamingState;
    protected State txReadyState;

    public void setStreamingState(State streamingState) {
        this.streamingState = streamingState;
    }

    public void setTransactionReadyState(State txReadyState) {
        this.txReadyState = txReadyState;
    }

    @Override
    public String name() {
        return "READY";
    }

    @Override
    protected void assertInitialized() {
        Preconditions.checkState((this.streamingState != null ? 1 : 0) != 0, (String)"Streaming state not set");
        Preconditions.checkState((this.txReadyState != null ? 1 : 0) != 0, (String)"TransactionReady state not set");
        super.assertInitialized();
    }

    @Override
    public State processUnsafe(RequestMessage message, StateMachineContext context) throws Exception {
        this.assertInitialized();
        if (message instanceof RunMessage) {
            RunMessage runMessage = (RunMessage)message;
            return this.processRunMessage(runMessage, context);
        }
        if (message instanceof BeginMessage) {
            BeginMessage beginMessage = (BeginMessage)message;
            return this.processBeginMessage(beginMessage, context);
        }
        return null;
    }

    protected State processRunMessage(RunMessage message, StateMachineContext context) throws Exception {
        long start = context.clock().millis();
        String programId = UUID.randomUUID().toString();
        context.connectionState().setCurrentTransactionId(programId);
        ProgramResultReference runResult = context.transactionManager().runProgram(programId, context.connection().loginContext(), message.databaseName(), message.statement(), message.params(), message.bookmarks(), message.getAccessMode().equals((Object)AccessMode.READ), message.transactionMetadata(), message.transactionTimeout(), context.connectionId());
        long end = context.clock().millis();
        context.connectionState().onMetadata(FIELDS_KEY, (AnyValue)Values.stringArray((String[])runResult.statementMetadata().fieldNames()));
        context.connectionState().onMetadata(FIRST_RECORD_AVAILABLE_KEY, (AnyValue)Values.longValue((long)(end - start)));
        context.connection().write((Object)StateSignal.ENTER_STREAMING);
        return this.streamingState;
    }

    protected State processBeginMessage(BeginMessage message, StateMachineContext context) throws Exception {
        String transactionId = context.transactionManager().begin(context.connection().loginContext(), message.databaseName(), message.bookmarks(), message.getAccessMode().equals((Object)AccessMode.READ), message.transactionMetadata(), message.transactionTimeout(), this.getTxType(message), context.connectionId());
        context.connectionState().setCurrentTransactionId(transactionId);
        context.connection().write((Object)StateSignal.ENTER_STREAMING);
        return this.txReadyState;
    }

    protected String getTxType(BeginMessage beginMessage) {
        return null;
    }
}

