/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v40.fsm;

import java.time.Clock;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.fsm.AbstractStateMachine;
import org.neo4j.bolt.protocol.common.fsm.StateMachineSPI;
import org.neo4j.bolt.protocol.v40.fsm.AutoCommitState;
import org.neo4j.bolt.protocol.v40.fsm.ConnectedState;
import org.neo4j.bolt.protocol.v40.fsm.FailedState;
import org.neo4j.bolt.protocol.v40.fsm.InTransactionState;
import org.neo4j.bolt.protocol.v40.fsm.InterruptedState;
import org.neo4j.bolt.protocol.v40.fsm.ReadyState;
import org.neo4j.bolt.transaction.TransactionManager;
import org.neo4j.kernel.database.DefaultDatabaseResolver;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;

public class StateMachineV40
extends AbstractStateMachine {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(StateMachineV40.class);

    public StateMachineV40(StateMachineSPI boltSPI, Connection connection, Clock clock, DefaultDatabaseResolver defaultDatabaseResolver, TransactionManager transactionManager) {
        super(boltSPI, connection, clock, defaultDatabaseResolver, transactionManager);
    }

    @Override
    protected AbstractStateMachine.States buildStates(MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap(ConnectedState.SHALLOW_SIZE + ReadyState.SHALLOW_SIZE + AutoCommitState.SHALLOW_SIZE + InTransactionState.SHALLOW_SIZE + FailedState.SHALLOW_SIZE + InterruptedState.SHALLOW_SIZE);
        ConnectedState connected = new ConnectedState();
        ReadyState ready = new ReadyState();
        AutoCommitState autoCommitState = new AutoCommitState();
        InTransactionState inTransaction = new InTransactionState();
        FailedState failed = new FailedState();
        InterruptedState interrupted = new InterruptedState();
        connected.setReadyState(ready);
        ready.setTransactionReadyState(inTransaction);
        ready.setStreamingState(autoCommitState);
        ready.setFailedState(failed);
        ready.setInterruptedState(interrupted);
        autoCommitState.setReadyState(ready);
        autoCommitState.setFailedState(failed);
        autoCommitState.setInterruptedState(interrupted);
        inTransaction.setReadyState(ready);
        inTransaction.setFailedState(failed);
        inTransaction.setInterruptedState(interrupted);
        failed.setInterruptedState(interrupted);
        interrupted.setReadyState(ready);
        return new AbstractStateMachine.States(connected, failed);
    }
}

