/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v40.messaging.decoder;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.neo4j.bolt.protocol.common.bookmark.Bookmark;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.message.AccessMode;
import org.neo4j.bolt.protocol.v40.messaging.request.BeginMessage;
import org.neo4j.bolt.protocol.v40.messaging.util.MessageMetadataParserV40;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.error.struct.IllegalStructArgumentException;
import org.neo4j.packstream.error.struct.IllegalStructSizeException;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.io.value.PackstreamValueReader;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.packstream.struct.StructReader;
import org.neo4j.values.virtual.MapValue;

public class BeginMessageDecoder
implements StructReader<Connection, BeginMessage> {
    private static final BeginMessageDecoder INSTANCE = new BeginMessageDecoder();

    protected BeginMessageDecoder() {
    }

    public static BeginMessageDecoder getInstance() {
        return INSTANCE;
    }

    @Override
    public short getTag() {
        return 17;
    }

    @Override
    public BeginMessage read(Connection ctx, PackstreamBuf buffer, StructHeader header) throws PackstreamReaderException {
        MapValue metadata;
        if (header.length() != 1L) {
            throw new IllegalStructSizeException(1L, header.length());
        }
        PackstreamValueReader<Connection> valueReader = ctx.valueReader(buffer);
        try {
            metadata = valueReader.readMap();
        }
        catch (PackstreamReaderException ex) {
            throw new IllegalStructArgumentException("metadata", ex);
        }
        List<Bookmark> bookmarks = MessageMetadataParserV40.parseBookmarks(ctx.connector().bookmarkParser(), metadata);
        try {
            Duration txTimeout = MessageMetadataParserV40.parseTransactionTimeout(metadata);
            AccessMode accessMode = MessageMetadataParserV40.parseAccessMode(metadata);
            Map<String, Object> txMetadata = MessageMetadataParserV40.parseTransactionMetadata(metadata);
            String databaseName = MessageMetadataParserV40.parseDatabaseName(metadata);
            return this.newBeginMessage(metadata, bookmarks, txTimeout, accessMode, txMetadata, databaseName);
        }
        catch (PackstreamReaderException ex) {
            throw new IllegalStructArgumentException("metadata", ex);
        }
    }

    protected BeginMessage newBeginMessage(MapValue metadata, List<Bookmark> bookmarks, Duration txTimeout, AccessMode accessMode, Map<String, Object> txMetadata, String databaseName) throws PackstreamReaderException {
        return new BeginMessage(metadata, bookmarks, txTimeout, accessMode, txMetadata, databaseName);
    }
}

