/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v40.messaging.decoder;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.neo4j.bolt.protocol.common.bookmark.Bookmark;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.message.AccessMode;
import org.neo4j.bolt.protocol.v40.messaging.request.RunMessage;
import org.neo4j.bolt.protocol.v40.messaging.util.MessageMetadataParserV40;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.error.struct.IllegalStructArgumentException;
import org.neo4j.packstream.error.struct.IllegalStructSizeException;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.io.value.PackstreamValueReader;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.packstream.struct.StructReader;
import org.neo4j.values.virtual.MapValue;

public class RunMessageDecoder
implements StructReader<Connection, RunMessage> {
    private static final RunMessageDecoder INSTANCE = new RunMessageDecoder();

    protected RunMessageDecoder() {
    }

    public static RunMessageDecoder getInstance() {
        return INSTANCE;
    }

    @Override
    public short getTag() {
        return 16;
    }

    @Override
    public RunMessage read(Connection ctx, PackstreamBuf buffer, StructHeader header) throws PackstreamReaderException {
        MapValue metadata;
        MapValue params;
        String statement;
        if (header.length() != 3L) {
            throw new IllegalStructSizeException(3L, header.length());
        }
        PackstreamValueReader<Connection> valueReader = ctx.valueReader(buffer);
        try {
            statement = buffer.readString();
        }
        catch (PackstreamReaderException ex) {
            throw new IllegalStructArgumentException("statement", ex);
        }
        try {
            params = valueReader.readMap();
        }
        catch (PackstreamReaderException ex) {
            throw new IllegalStructArgumentException("params", ex);
        }
        try {
            metadata = valueReader.readMap();
        }
        catch (PackstreamReaderException ex) {
            throw new IllegalStructArgumentException("metadata", ex);
        }
        try {
            List<Bookmark> bookmarks = MessageMetadataParserV40.parseBookmarks(ctx.connector().bookmarkParser(), metadata);
            Duration txTimeout = MessageMetadataParserV40.parseTransactionTimeout(metadata);
            AccessMode accessMode = MessageMetadataParserV40.parseAccessMode(metadata);
            Map<String, Object> txMetadata = MessageMetadataParserV40.parseTransactionMetadata(metadata);
            String databaseName = MessageMetadataParserV40.parseDatabaseName(metadata);
            return this.newRunMessage(statement, params, metadata, bookmarks, txTimeout, accessMode, txMetadata, databaseName);
        }
        catch (PackstreamReaderException ex) {
            throw new IllegalStructArgumentException("metadata", ex);
        }
    }

    protected RunMessage newRunMessage(String statement, MapValue params, MapValue meta, List<Bookmark> bookmarks, Duration txTimeout, AccessMode accessMode, Map<String, Object> txMetadata, String databaseName) throws PackstreamReaderException {
        return new RunMessage(statement, params, meta, bookmarks, txTimeout, accessMode, txMetadata, databaseName);
    }
}

