/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v43.message.decoder;

import java.util.List;
import java.util.Optional;
import org.neo4j.bolt.protocol.common.bookmark.Bookmark;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.v43.message.request.RouteMessage;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.error.struct.IllegalStructSizeException;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.io.Type;
import org.neo4j.packstream.io.value.PackstreamValueReader;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.packstream.struct.StructReader;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

public class RouteMessageDecoder
implements StructReader<Connection, RouteMessage> {
    private static final RouteMessageDecoder INSTANCE = new RouteMessageDecoder();

    protected RouteMessageDecoder() {
    }

    public static RouteMessageDecoder getInstance() {
        return INSTANCE;
    }

    @Override
    public short getTag() {
        return 102;
    }

    @Override
    public RouteMessage read(Connection connection, PackstreamBuf buffer, StructHeader header) throws PackstreamReaderException {
        if (header.length() != 3L) {
            throw new IllegalStructSizeException(3L, header.length());
        }
        PackstreamValueReader<Connection> valueReader = connection.valueReader(buffer);
        MapValue routingContext = valueReader.readMap();
        List<Bookmark> bookmarkList = List.of();
        if (buffer.peekType() != Type.NONE) {
            bookmarkList = connection.connector().bookmarkParser().parseBookmarks(valueReader.readList());
        }
        String databaseName = Optional.of(valueReader.readValue()).filter(any -> any != Values.NO_VALUE && any instanceof TextValue).map(any -> ((TextValue)any).stringValue()).orElse(null);
        return new RouteMessage(routingContext, bookmarkList, databaseName);
    }
}

