/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration;

import java.nio.file.Path;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.Internal;
import org.neo4j.configuration.SettingImpl;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.configuration.SettingsDeclaration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.ByteUnit;

public class BootloaderSettings
implements SettingsDeclaration {
    @Description(value="Name of the Windows Service managing Neo4j when installed using `neo4j install-service`. Only applicable on Windows OS. Note: This must be unique for each individual installation.")
    public static final Setting<String> windows_service_name = SettingImpl.newBuilder("server.windows_service_name", SettingValueParsers.STRING, "neo4j").build();
    @Internal
    @Description(value="Path of the lib directory")
    public static final Setting<Path> windows_tools_directory = SettingImpl.newBuilder("internal.server.directories.windows_tools", SettingValueParsers.PATH, Path.of("bin", "tools")).setDependency(GraphDatabaseSettings.neo4j_home).immutable().build();
    @Description(value="Additional JVM arguments. Argument order can be significant. To use a Java commercial feature, the argument to unlock commercial features must precede the argument to enable the specific feature in the config value string. For example, to use Flight Recorder, `-XX:+UnlockCommercialFeatures` must come before `-XX:+FlightRecorder`.")
    public static final Setting<String> additional_jvm = SettingImpl.newBuilder("server.jvm.additional", SettingValueParsers.JVM_ADDITIONAL, null).build();
    @Description(value="Initial heap size. By default it is calculated based on available system resources.")
    public static final Setting<Long> initial_heap_size = SettingImpl.newBuilder("server.memory.heap.initial_size", SettingValueParsers.BYTES, null).build();
    @Description(value="Maximum heap size. By default it is calculated based on available system resources.")
    public static final Setting<Long> max_heap_size = SettingImpl.newBuilder("server.memory.heap.max_size", SettingValueParsers.BYTES, null).build();
    @Description(value="GC Logging Options")
    public static final Setting<String> gc_logging_options = SettingImpl.newBuilder("server.logs.gc.options", SettingValueParsers.STRING, "-Xlog:gc*,safepoint,age*=trace").build();
    @Description(value="Number of GC logs to keep.")
    public static final Setting<Integer> gc_logging_rotation_keep_number = SettingImpl.newBuilder("server.logs.gc.rotation.keep_number", SettingValueParsers.INT, 5).build();
    @Description(value="Size of each GC log that is kept.")
    public static final Setting<Long> gc_logging_rotation_size = SettingImpl.newBuilder("server.logs.gc.rotation.size", SettingValueParsers.BYTES, ByteUnit.mebiBytes((long)20L)).build();
    @Description(value="Enable GC Logging")
    public static final Setting<Boolean> gc_logging_enabled = SettingImpl.newBuilder("server.logs.gc.enabled", SettingValueParsers.BOOL, false).build();
    @Description(value="Path of the run directory. This directory holds Neo4j's runtime state, such as a pidfile when it is running in the background. The pidfile is created when starting neo4j and removed when stopping it. It may be placed on an in-memory filesystem such as tmpfs.")
    public static final Setting<Path> run_directory = SettingImpl.newBuilder("server.directories.run", SettingValueParsers.PATH, Path.of("run", new String[0])).setDependency(GraphDatabaseSettings.neo4j_home).immutable().build();
    @Internal
    @Description(value="Path of the pid file.")
    public static final Setting<Path> pid_file = SettingImpl.newBuilder("internal.server.directories.pid_file", SettingValueParsers.PATH, Path.of("neo4j.pid", new String[0])).setDependency(run_directory).immutable().build();
    @Description(value="Path of the lib directory")
    public static final Setting<Path> lib_directory = SettingImpl.newBuilder("server.directories.lib", SettingValueParsers.PATH, Path.of("lib", new String[0])).setDependency(GraphDatabaseSettings.neo4j_home).immutable().build();
}

