/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted;

import inet.ipaddr.IPAddressString;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.neo4j.csv.reader.BufferOverflowException;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.CharSeekers;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.csv.reader.Mark;
import org.neo4j.csv.reader.Readables;
import org.neo4j.cypher.internal.runtime.ResourceManager;
import org.neo4j.cypher.internal.runtime.interpreted.CSVResource;
import org.neo4j.cypher.internal.runtime.interpreted.CSVResources$;
import org.neo4j.cypher.internal.runtime.interpreted.TheCookieManager$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.ExternalCSVResource;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.LoadCsvIterator;
import org.neo4j.exceptions.CypherExecutionException;
import org.neo4j.exceptions.LoadExternalResourceException;
import org.neo4j.internal.kernel.api.AutoCloseablePlus;
import org.neo4j.kernel.impl.security.WebURLAccessRule;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005=t!B\n\u0015\u0011\u0003\tc!B\u0012\u0015\u0011\u0003!\u0003\"B\u0016\u0002\t\u0003a\u0003bB\u0017\u0002\u0005\u0004%\tA\f\u0005\u0007e\u0005\u0001\u000b\u0011B\u0018\t\u000fM\n!\u0019!C\u0001i!1\u0001(\u0001Q\u0001\nUBq!O\u0001C\u0002\u0013\u0005a\u0006\u0003\u0004;\u0003\u0001\u0006Ia\f\u0005\u0006w\u0005!I\u0001\u0010\u0004\u0005GQ\u0001A\n\u0003\u0005T\u0015\t\u0005\t\u0015!\u0003U\u0011\u0015Y#\u0002\"\u0001Y\u0011\u0015Y&\u0002\"\u0001]\u0011%\t)CCI\u0001\n\u0003\t9\u0003C\u0004\u0002>)!I!a\u0010\t\u000f\u0005-#\u0002\"\u0003\u0002N!I\u0011q\r\u0006\u0012\u0002\u0013%\u0011\u0011\u000e\u0005\n\u0003[R\u0011\u0013!C\u0005\u0003S\nAbQ*W%\u0016\u001cx.\u001e:dKNT!!\u0006\f\u0002\u0017%tG/\u001a:qe\u0016$X\r\u001a\u0006\u0003/a\tqA];oi&lWM\u0003\u0002\u001a5\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u001c9\u000511-\u001f9iKJT!!\b\u0010\u0002\u000b9,w\u000e\u000e6\u000b\u0003}\t1a\u001c:h\u0007\u0001\u0001\"AI\u0001\u000e\u0003Q\u0011AbQ*W%\u0016\u001cx.\u001e:dKN\u001c\"!A\u0013\u0011\u0005\u0019JS\"A\u0014\u000b\u0003!\nQa]2bY\u0006L!AK\u0014\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0011%\u0001\rE\u000b\u001a\u000bU\u000b\u0014+`\r&+E\nR0U\u000bJk\u0015JT!U\u001fJ+\u0012a\f\t\u0003MAJ!!M\u0014\u0003\t\rC\u0017M]\u0001\u001a\t\u00163\u0015)\u0016'U?\u001aKU\t\u0014#`)\u0016\u0013V*\u0013(B)>\u0013\u0006%A\nE\u000b\u001a\u000bU\u000b\u0014+`\u0005V3e)\u0012*`'&SV)F\u00016!\t1c'\u0003\u00028O\t\u0019\u0011J\u001c;\u0002)\u0011+e)Q+M)~\u0013UK\u0012$F%~\u001b\u0016JW#!\u0003I!UIR!V\u0019R{\u0016+V(U\u000b~\u001b\u0005*\u0011*\u0002'\u0011+e)Q+M)~\u000bVk\u0014+F?\u000eC\u0015I\u0015\u0011\u0002\r\r|gNZ5h)\riTI\u0013\t\u0003}\rk\u0011a\u0010\u0006\u0003\u0001\u0006\u000baA]3bI\u0016\u0014(B\u0001\"\u001d\u0003\r\u00197O^\u0005\u0003\t~\u0012QbQ8oM&<WO]1uS>t\u0007\"\u0002$\n\u0001\u00049\u0015A\u00067fO\u0006\u001c\u0017pQ:w#V|G/Z#tG\u0006\u0004\u0018N\\4\u0011\u0005\u0019B\u0015BA%(\u0005\u001d\u0011un\u001c7fC:DQaS\u0005A\u0002U\nQbY:w\u0005V4g-\u001a:TSj,7c\u0001\u0006&\u001bB\u0011a*U\u0007\u0002\u001f*\u0011\u0001\u000bF\u0001\u0006a&\u0004Xm]\u0005\u0003%>\u00131#\u0012=uKJt\u0017\r\\\"T-J+7o\\;sG\u0016\fqB]3t_V\u00148-Z'b]\u0006<WM\u001d\t\u0003+Zk\u0011AF\u0005\u0003/Z\u0011qBU3t_V\u00148-Z'b]\u0006<WM\u001d\u000b\u00033j\u0003\"A\t\u0006\t\u000bMc\u0001\u0019\u0001+\u0002\u001d\u001d,GoQ:w\u0013R,'/\u0019;peRYQ\f\u00196\u0002\u0002\u0005m\u0011QDA\u0011!\tqe,\u0003\u0002`\u001f\nyAj\\1e\u0007N4\u0018\n^3sCR|'\u000fC\u0003b\u001b\u0001\u0007!-A\u0002ve2\u0004\"a\u00195\u000e\u0003\u0011T!!\u001a4\u0002\u00079,GOC\u0001h\u0003\u0011Q\u0017M^1\n\u0005%$'aA+S\u0019\")1.\u0004a\u0001Y\u0006Y\u0011\u000e\u001d\"m_\u000e\\G.[:u!\riW\u000f\u001f\b\u0003]Nt!a\u001c:\u000e\u0003AT!!\u001d\u0011\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0013B\u0001;(\u0003\u001d\u0001\u0018mY6bO\u0016L!A^<\u0003\t1K7\u000f\u001e\u0006\u0003i\u001e\u0002\"!\u001f@\u000e\u0003iT!a\u001f?\u0002\r%\u0004\u0018\r\u001a3s\u0015\u0005i\u0018\u0001B5oKRL!a >\u0003\u001f%\u0003\u0016\t\u001a3sKN\u001c8\u000b\u001e:j]\u001eDq!a\u0001\u000e\u0001\u0004\t)!A\bgS\u0016dG\rV3s[&t\u0017\r^8s!\u00151\u0013qAA\u0006\u0013\r\tIa\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u00055\u0011Q\u0003\b\u0005\u0003\u001f\t\t\u0002\u0005\u0002pO%\u0019\u00111C\u0014\u0002\rA\u0013X\rZ3g\u0013\u0011\t9\"!\u0007\u0003\rM#(/\u001b8h\u0015\r\t\u0019b\n\u0005\u0006\r6\u0001\ra\u0012\u0005\u0007\u0003?i\u0001\u0019A\u001b\u0002\u0015\t,hMZ3s'&TX\r\u0003\u0005\u0002$5\u0001\n\u00111\u0001H\u0003\u001dAW-\u00193feN\f\u0001dZ3u\u0007N4\u0018\n^3sCR|'\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\tICK\u0002H\u0003WY#!!\f\u0011\t\u0005=\u0012\u0011H\u0007\u0003\u0003cQA!a\r\u00026\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003o9\u0013AC1o]>$\u0018\r^5p]&!\u00111HA\u0019\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\nO\u0016$(+Z1eKJ$b!!\u0011\u0002H\u0005%\u0003c\u0001 \u0002D%\u0019\u0011QI \u0003\u0019\rC\u0017M\u001d*fC\u0012\f'\r\\3\t\u000b\u0005|\u0001\u0019\u00012\t\u000b-|\u0001\u0019\u00017\u0002\u0015=\u0004XM\\*ue\u0016\fW\u000e\u0006\u0006\u0002P\u0005m\u0013QLA0\u0003G\u0002B!!\u0015\u0002X5\u0011\u00111\u000b\u0006\u0004\u0003+2\u0017AA5p\u0013\u0011\tI&a\u0015\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\u001c\u0005\u0006CB\u0001\rA\u0019\u0005\u0006WB\u0001\r\u0001\u001c\u0005\t\u0003C\u0002\u0002\u0013!a\u0001k\u0005\t2m\u001c8oK\u000e$\u0018n\u001c8US6,w.\u001e;\t\u0011\u0005\u0015\u0004\u0003%AA\u0002U\n1B]3bIRKW.Z8vi\u0006!r\u000e]3o'R\u0014X-Y7%I\u00164\u0017-\u001e7uIM*\"!a\u001b+\u0007U\nY#\u0001\u000bpa\u0016t7\u000b\u001e:fC6$C-\u001a4bk2$H\u0005\u000e")
public class CSVResources
implements ExternalCSVResource {
    private final ResourceManager resourceManager;

    public static char DEFAULT_QUOTE_CHAR() {
        return CSVResources$.MODULE$.DEFAULT_QUOTE_CHAR();
    }

    public static int DEFAULT_BUFFER_SIZE() {
        return CSVResources$.MODULE$.DEFAULT_BUFFER_SIZE();
    }

    public static char DEFAULT_FIELD_TERMINATOR() {
        return CSVResources$.MODULE$.DEFAULT_FIELD_TERMINATOR();
    }

    @Override
    public LoadCsvIterator getCsvIterator(URL url, List<IPAddressString> ipBlocklist, Option<String> fieldTerminator, boolean legacyCsvQuoteEscaping, int bufferSize, boolean headers) {
        CharReadable reader = this.getReader(url, ipBlocklist);
        char delimiter = BoxesRunTime.unboxToChar((Object)fieldTerminator.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToCharacter((char)x$1.charAt(0))).getOrElse((Function0)(JFunction0.mcC.sp & Serializable)() -> CSVResources$.MODULE$.DEFAULT_FIELD_TERMINATOR()));
        CharSeeker seeker = CharSeekers.charSeeker((CharReadable)reader, (Configuration)CSVResources$.MODULE$.org$neo4j$cypher$internal$runtime$interpreted$CSVResources$$config(legacyCsvQuoteEscaping, bufferSize), (boolean)false);
        Extractors.TextValueExtractor extractor = new Extractors(delimiter).textValue();
        char intDelimiter = delimiter;
        Mark mark = new Mark();
        CSVResource resource = new CSVResource(url, (AutoCloseable)seeker);
        this.resourceManager.trace((AutoCloseablePlus)resource);
        return new LoadCsvIterator(null, resource, seeker, mark, intDelimiter, extractor){
            private long lastProcessed;
            private boolean readAll;
            private Value[] nextRow;
            private final CSVResource resource$1;
            private final CharSeeker seeker$1;
            private final Mark mark$1;
            private final int intDelimiter$1;
            private final Extractors.TextValueExtractor extractor$1;

            public long lastProcessed() {
                return this.lastProcessed;
            }

            private void lastProcessed_$eq(long x$1) {
                this.lastProcessed = x$1;
            }

            public boolean readAll() {
                return this.readAll;
            }

            private void readAll_$eq(boolean x$1) {
                this.readAll = x$1;
            }

            public void closeMore() {
                this.resource$1.close();
            }

            private Value[] readNextRow() {
                ArrayBuffer buffer = new ArrayBuffer();
                try {
                    while (this.seeker$1.seek(this.mark$1, this.intDelimiter$1)) {
                        Value value = (Value)this.seeker$1.tryExtract(this.mark$1, (Extractor)this.extractor$1);
                        buffer.$plus$eq((Object)(!this.extractor$1.isEmpty((Object)value) ? value : Values.NO_VALUE));
                        if (!this.mark$1.isEndOfLine()) continue;
                        if (buffer.isEmpty()) {
                            return null;
                        }
                        return (Value[])buffer.toArray(ClassTag$.MODULE$.apply(Value.class));
                    }
                }
                catch (BufferOverflowException e) {
                    throw new CypherExecutionException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Tried to read a field larger than the current buffer size.\n                | Make sure that the field doesn't have an unterminated quote,\n                | if it doesn't you can try increasing the buffer size via `dbms.import.csv.buffer_size`.")), (Throwable)e);
                }
                if (buffer.isEmpty()) {
                    return null;
                }
                return (Value[])buffer.toArray(ClassTag$.MODULE$.apply(Value.class));
            }

            private Value[] nextRow() {
                return this.nextRow;
            }

            private void nextRow_$eq(Value[] x$1) {
                this.nextRow = x$1;
            }

            public boolean innerHasNext() {
                return this.nextRow() != null;
            }

            public Value[] next() {
                Object object = !this.hasNext() ? package$.MODULE$.Iterator().empty().next() : BoxedUnit.UNIT;
                Value[] row = this.nextRow();
                this.nextRow_$eq(this.readNextRow());
                this.lastProcessed_$eq(this.lastProcessed() + 1L);
                this.readAll_$eq(!this.hasNext());
                return row;
            }
            {
                this.resource$1 = resource$1;
                this.seeker$1 = seeker$1;
                this.mark$1 = mark$1;
                this.intDelimiter$1 = intDelimiter$1;
                this.extractor$1 = extractor$1;
                this.lastProcessed = 0L;
                this.readAll = false;
                this.nextRow = this.readNextRow();
            }
        };
    }

    @Override
    public boolean getCsvIterator$default$6() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private CharReadable getReader(URL url, List<IPAddressString> ipBlocklist) {
        void v2;
        try {
            void var3_5;
            CharReadable charReadable;
            String string = url.getProtocol();
            String string2 = "file";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                charReadable = Readables.files((Charset)StandardCharsets.UTF_8, (Path[])new Path[]{Paths.get(url.toURI())});
            } else {
                InputStream inputStream = this.openStream(url, ipBlocklist, this.openStream$default$3(), this.openStream$default$4());
                charReadable = Readables.wrap((InputStream)inputStream, (String)url.toString(), (Charset)StandardCharsets.UTF_8, (long)0L);
            }
            CharReadable reader = charReadable;
            v2 = var3_5;
        }
        catch (IOException e) {
            throw new LoadExternalResourceException("Couldn't load the external resource at: " + url, (Throwable)e);
        }
        return v2;
    }

    private InputStream openStream(URL url, List<IPAddressString> ipBlocklist, int connectionTimeout, int readTimeout) {
        URLConnection uRLConnection;
        if (url.getProtocol().startsWith("http")) {
            TheCookieManager$.MODULE$.ensureEnabled();
        }
        if (ipBlocklist.nonEmpty()) {
            uRLConnection = WebURLAccessRule.checkUrlIncludingHops((URL)url, (java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava(ipBlocklist).asJava());
        } else {
            URLConnection newCon = url.openConnection();
            newCon.setRequestProperty("User-Agent", "NeoLoadCSV_" + WebURLAccessRule.userAgent());
            uRLConnection = newCon;
        }
        HttpURLConnection con = uRLConnection;
        con.setConnectTimeout(connectionTimeout);
        con.setReadTimeout(readTimeout);
        InputStream stream = con.getInputStream();
        String string = con.getContentEncoding();
        switch (string == null ? 0 : string.hashCode()) {
            case 3189082: {
                if (!"gzip".equals(string)) break;
                return new GZIPInputStream(stream);
            }
            case 1545112619: {
                if (!"deflate".equals(string)) break;
                return new InflaterInputStream(stream);
            }
        }
        return stream;
    }

    private int openStream$default$3() {
        return 2000;
    }

    private int openStream$default$4() {
        return 600000;
    }

    public CSVResources(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }
}

