/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.planning;

import java.util.ArrayDeque;
import org.neo4j.cypher.internal.expressions.LiteralExtractor;
import org.neo4j.cypher.internal.planning.ListWriter;
import org.neo4j.cypher.internal.planning.NormalWriter;
import org.neo4j.cypher.internal.planning.Writer;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005m4AAD\b\u00015!)q\u0005\u0001C\u0001Q!91\u0006\u0001b\u0001\n\u0013a\u0003B\u0002\u001d\u0001A\u0003%Q\u0006C\u0003:\u0001\u0011\u0005!\bC\u0003B\u0001\u0011\u0005#\tC\u0003K\u0001\u0011\u00053\nC\u0003Q\u0001\u0011\u0005\u0013\u000bC\u0003S\u0001\u0011\u00053\u000bC\u0003a\u0001\u0011\u0005\u0013\rC\u0003g\u0001\u0011\u0005s\rC\u0003n\u0001\u0011\u0005\u0013\u000bC\u0003o\u0001\u0011\u0005s\u000eC\u0003x\u0001\u0011%\u0001PA\rQCJ\fW.\u001a;fe2KG/\u001a:bY\u0016CHO]1di>\u0014(B\u0001\t\u0012\u0003!\u0001H.\u00198oS:<'B\u0001\n\u0014\u0003!Ig\u000e^3s]\u0006d'B\u0001\u000b\u0016\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011acF\u0001\u0006]\u0016|GG\u001b\u0006\u00021\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aG\u0011\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\r\u0005s\u0017PU3g!\t\u0011S%D\u0001$\u0015\t!\u0013#A\u0006fqB\u0014Xm]:j_:\u001c\u0018B\u0001\u0014$\u0005Aa\u0015\u000e^3sC2,\u0005\u0010\u001e:bGR|'/\u0001\u0004=S:LGO\u0010\u000b\u0002SA\u0011!\u0006A\u0007\u0002\u001f\u0005)1\u000f^1dWV\tQ\u0006E\u0002/gUj\u0011a\f\u0006\u0003aE\nA!\u001e;jY*\t!'\u0001\u0003kCZ\f\u0017B\u0001\u001b0\u0005)\t%O]1z\t\u0016\fX/\u001a\t\u0003UYJ!aN\b\u0003\r]\u0013\u0018\u000e^3s\u0003\u0019\u0019H/Y2lA\u0005)a/\u00197vKV\t1\b\u0005\u0002=\u007f5\tQH\u0003\u0002?+\u00051a/\u00197vKNL!\u0001Q\u001f\u0003\u0011\u0005s\u0017PV1mk\u0016\f\u0011b\u001e:ji\u0016duN\\4\u0015\u0005\r3\u0005C\u0001\u000fE\u0013\t)UD\u0001\u0003V]&$\b\"B\u001d\u0006\u0001\u00049\u0005C\u0001\u000fI\u0013\tIUD\u0001\u0003M_:<\u0017\u0001D<sSR,'i\\8mK\u0006tGCA\"M\u0011\u0015Id\u00011\u0001N!\tab*\u0003\u0002P;\t9!i\\8mK\u0006t\u0017!C<sSR,g*\u001e7m)\u0005\u0019\u0015aC<sSR,7\u000b\u001e:j]\u001e$\"a\u0011+\t\u000beB\u0001\u0019A+\u0011\u0005YkfBA,\\!\tAV$D\u0001Z\u0015\tQ\u0016$\u0001\u0004=e>|GOP\u0005\u00039v\ta\u0001\u0015:fI\u00164\u0017B\u00010`\u0005\u0019\u0019FO]5oO*\u0011A,H\u0001\foJLG/\u001a#pk\ndW\r\u0006\u0002DE\")\u0011(\u0003a\u0001GB\u0011A\u0004Z\u0005\u0003Kv\u0011a\u0001R8vE2,\u0017!\u00032fO&tG*[:u)\t\u0019\u0005\u000eC\u0003j\u0015\u0001\u0007!.\u0001\u0003tSj,\u0007C\u0001\u000fl\u0013\taWDA\u0002J]R\fq!\u001a8e\u0019&\u001cH/\u0001\bxe&$XMQ=uK\u0006\u0013(/Y=\u0015\u0005\r\u0003\b\"B\u001d\r\u0001\u0004\t\bc\u0001\u000fsi&\u00111/\b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u00039UL!A^\u000f\u0003\t\tKH/Z\u0001\u0006oJLG/\u001a\u000b\u0003\u0007fDQA_\u0007A\u0002m\n\u0001\"\u00198z-\u0006dW/\u001a")
public class ParameterLiteralExtractor
implements LiteralExtractor {
    private final ArrayDeque<Writer> stack = new ArrayDeque();

    private ArrayDeque<Writer> stack() {
        return this.stack;
    }

    public AnyValue value() {
        Predef$.MODULE$.require(this.stack().size() == 1);
        return this.stack().peek().value();
    }

    public void writeLong(long value) {
        this.write((AnyValue)Values.longValue((long)value));
    }

    public void writeBoolean(boolean value) {
        this.write((AnyValue)Values.booleanValue((boolean)value));
    }

    public void writeNull() {
        this.write((AnyValue)Values.NO_VALUE);
    }

    public void writeString(String value) {
        this.write((AnyValue)Values.stringValue((String)value));
    }

    public void writeDouble(double value) {
        this.write((AnyValue)Values.doubleValue((double)value));
    }

    public void beginList(int size) {
        this.stack().push(new ListWriter(size));
    }

    public void endList() {
        Predef$.MODULE$.require(!this.stack().isEmpty());
        this.write(this.stack().pop().value());
    }

    public void writeByteArray(byte[] value) {
        this.write((AnyValue)Values.byteArray((byte[])value));
    }

    private void write(AnyValue anyValue) {
        Predef$.MODULE$.require(!this.stack().isEmpty());
        Writer current = this.stack().peek();
        current.write(anyValue);
    }

    public ParameterLiteralExtractor() {
        this.stack().push(new NormalWriter());
    }
}

