/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.index.internal.gbptree.GBPTreeOpenOptions;
import org.neo4j.index.internal.gbptree.GBPTreeVisitor;
import org.neo4j.index.internal.gbptree.GenerationSafePointerPair;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.Meta;
import org.neo4j.index.internal.gbptree.RootMappingLayout;
import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.index.internal.gbptree.TreeState;
import org.neo4j.index.internal.gbptree.TreeStatePair;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageCursorUtil;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.util.Preconditions;

public class GBPTreeStructure<ROOT_KEY, DATA_KEY, DATA_VALUE> {
    private final TreeNode<ROOT_KEY, RootMappingLayout.RootMappingValue> rootTreeNode;
    private final Layout<ROOT_KEY, RootMappingLayout.RootMappingValue> rootLayout;
    private final TreeNode<DATA_KEY, DATA_VALUE> dataTreeNode;
    private final Layout<DATA_KEY, DATA_VALUE> dataLayout;
    private final long stableGeneration;
    private final long unstableGeneration;

    GBPTreeStructure(TreeNode<ROOT_KEY, RootMappingLayout.RootMappingValue> rootTreeNode, Layout<ROOT_KEY, RootMappingLayout.RootMappingValue> rootLayout, TreeNode<DATA_KEY, DATA_VALUE> dataTreeNode, Layout<DATA_KEY, DATA_VALUE> dataLayout, long stableGeneration, long unstableGeneration) {
        this.rootTreeNode = rootTreeNode;
        this.rootLayout = rootLayout;
        this.dataTreeNode = dataTreeNode;
        this.dataLayout = dataLayout;
        this.stableGeneration = stableGeneration;
        this.unstableGeneration = unstableGeneration;
    }

    public static void visitMeta(PageCache pageCache, Path file, GBPTreeVisitor visitor, String databaseName, CursorContext cursorContext, ImmutableSet<OpenOption> openOptions) throws IOException {
        ImmutableSet options = openOptions.newWithoutAll(Arrays.asList(GBPTreeOpenOptions.values())).newWith((Object)StandardOpenOption.READ);
        try (PagedFile pagedFile = pageCache.map(file, pageCache.pageSize(), databaseName, options);
             PageCursor cursor = pagedFile.io(0L, 1, cursorContext);){
            GBPTreeStructure.visitMeta(cursor, visitor);
        }
    }

    public static void visitState(PageCache pageCache, Path file, GBPTreeVisitor visitor, String databaseName, CursorContext cursorContext, ImmutableSet<OpenOption> openOptions) throws IOException {
        ImmutableSet options = openOptions.newWithoutAll(Arrays.asList(GBPTreeOpenOptions.values())).newWith((Object)StandardOpenOption.READ);
        try (PagedFile pagedFile = pageCache.map(file, pageCache.pageSize(), databaseName, options);
             PageCursor cursor = pagedFile.io(1L, 1, cursorContext);){
            GBPTreeStructure.visitTreeState(cursor, visitor);
        }
    }

    private static void visitMeta(PageCursor cursor, GBPTreeVisitor visitor) throws IOException {
        PageCursorUtil.goTo((PageCursor)cursor, (String)"meta page", (long)0L);
        Meta meta = Meta.read(cursor);
        visitor.meta(meta);
    }

    static void visitTreeState(PageCursor cursor, GBPTreeVisitor visitor) throws IOException {
        Pair<TreeState, TreeState> statePair = TreeStatePair.readStatePages(cursor, 1L, 2L);
        visitor.treeState(statePair);
    }

    void visitTree(PageCursor cursor, GBPTreeVisitor<ROOT_KEY, DATA_KEY, DATA_VALUE> visitor, CursorContext cursorContext) throws IOException {
        boolean isDataTree;
        long currentPage = cursor.getCurrentPageId();
        GBPTreeStructure.visitTreeState(cursor, visitor);
        TreeNode.goTo(cursor, "back to tree node from reading state", currentPage);
        GBPTreeStructure.assertOnTreeNode(cursor);
        do {
            boolean bl = isDataTree = TreeNode.layerType(cursor) == 0;
        } while (cursor.shouldRetry());
        visitor.beginTree(isDataTree);
        int level = 0;
        do {
            visitor.beginLevel(level);
            long leftmostSibling = cursor.getCurrentPageId();
            this.visitLevel(cursor, visitor, cursorContext);
            visitor.endLevel(level);
            ++level;
            TreeNode.goTo(cursor, "back", leftmostSibling);
        } while (this.goToLeftmostChild(cursor));
        visitor.endTree(isDataTree);
    }

    private static void assertOnTreeNode(PageCursor cursor) throws IOException {
        boolean isLeaf;
        boolean isInternal;
        byte nodeType;
        do {
            nodeType = TreeNode.nodeType(cursor);
            isInternal = TreeNode.isInternal(cursor);
            isLeaf = TreeNode.isLeaf(cursor);
        } while (cursor.shouldRetry());
        if (nodeType != 1) {
            throw new IllegalArgumentException("Cursor is not pinned to a tree node page. pageId:" + cursor.getCurrentPageId());
        }
        if (!isInternal && !isLeaf) {
            throw new IllegalArgumentException("Cursor is not pinned to a page containing a tree node. pageId:" + cursor.getCurrentPageId());
        }
    }

    void visitTreeNode(PageCursor cursor, GBPTreeVisitor<ROOT_KEY, DATA_KEY, DATA_VALUE> visitor, CursorContext cursorContext) throws IOException {
        boolean isDataNode;
        int keyCount;
        boolean isLeaf;
        long generation = -1L;
        do {
            isLeaf = TreeNode.isLeaf(cursor);
            keyCount = TreeNode.keyCount(cursor);
            isDataNode = TreeNode.layerType(cursor) == 0;
            generation = TreeNode.generation(cursor);
        } while (cursor.shouldRetry());
        Preconditions.checkState((boolean)this.treeNode(isDataNode).reasonableKeyCount(keyCount), (String)"Unexpected keyCount %d", (Object[])new Object[]{keyCount});
        visitor.beginNode(cursor.getCurrentPageId(), isLeaf, generation, keyCount);
        for (int i = 0; i < keyCount; ++i) {
            if (isDataNode) {
                this.visitDataEntry(cursor, visitor, cursorContext, isLeaf, i);
                continue;
            }
            this.visitRootEntry(cursor, visitor, cursorContext, isLeaf, i);
        }
        if (!isLeaf) {
            long child;
            do {
                child = GenerationSafePointerPair.pointer(this.treeNode(isDataNode).childAt(cursor, keyCount, this.stableGeneration, this.unstableGeneration));
            } while (cursor.shouldRetry());
            visitor.position(keyCount);
            visitor.child(child);
        }
        visitor.endNode(cursor.getCurrentPageId());
    }

    private TreeNode<?, ?> treeNode(boolean isDataNode) {
        return isDataNode ? this.dataTreeNode : this.rootTreeNode;
    }

    private void visitDataEntry(PageCursor cursor, GBPTreeVisitor<ROOT_KEY, DATA_KEY, DATA_VALUE> visitor, CursorContext cursorContext, boolean isLeaf, int i) throws IOException {
        long offloadId;
        Object key = this.dataLayout.newKey();
        TreeNode.ValueHolder<DATA_VALUE> value = new TreeNode.ValueHolder<DATA_VALUE>(this.dataLayout.newValue());
        long child = -1L;
        do {
            TreeNode.Type type = isLeaf ? TreeNode.Type.LEAF : TreeNode.Type.INTERNAL;
            offloadId = this.dataTreeNode.offloadIdAt(cursor, i, type);
            if (isLeaf) {
                this.dataTreeNode.keyValueAt(cursor, key, value, i, cursorContext);
                continue;
            }
            this.dataTreeNode.keyAt(cursor, key, i, type, cursorContext);
            child = GenerationSafePointerPair.pointer(this.dataTreeNode.childAt(cursor, i, this.stableGeneration, this.unstableGeneration));
        } while (cursor.shouldRetry());
        visitor.position(i);
        if (isLeaf) {
            visitor.key(key, isLeaf, offloadId);
            visitor.value(value.value);
            this.dataTreeNode.deepVisitValue(cursor, i, visitor);
        } else {
            visitor.child(child);
            visitor.key(key, isLeaf, offloadId);
        }
    }

    private void visitRootEntry(PageCursor cursor, GBPTreeVisitor<ROOT_KEY, DATA_KEY, DATA_VALUE> visitor, CursorContext cursorContext, boolean isLeaf, int i) throws IOException {
        long offloadId;
        Object key = this.rootLayout.newKey();
        TreeNode.ValueHolder<RootMappingLayout.RootMappingValue> value = new TreeNode.ValueHolder<RootMappingLayout.RootMappingValue>(this.rootLayout.newValue());
        long child = -1L;
        do {
            TreeNode.Type type = isLeaf ? TreeNode.Type.LEAF : TreeNode.Type.INTERNAL;
            offloadId = this.rootTreeNode.offloadIdAt(cursor, i, type);
            if (isLeaf) {
                this.rootTreeNode.keyValueAt(cursor, key, value, i, cursorContext);
                continue;
            }
            this.rootTreeNode.keyAt(cursor, key, i, type, cursorContext);
            child = GenerationSafePointerPair.pointer(this.rootTreeNode.childAt(cursor, i, this.stableGeneration, this.unstableGeneration));
        } while (cursor.shouldRetry());
        visitor.position(i);
        if (isLeaf) {
            visitor.rootKey(key, isLeaf, offloadId);
            visitor.rootMapping(((RootMappingLayout.RootMappingValue)value.value).rootId, ((RootMappingLayout.RootMappingValue)value.value).rootGeneration);
        } else {
            visitor.child(child);
            visitor.rootKey(key, isLeaf, offloadId);
        }
    }

    private boolean goToLeftmostChild(PageCursor cursor) throws IOException {
        boolean isDataNode;
        boolean isInternal;
        long leftmostSibling = -1L;
        do {
            isInternal = TreeNode.isInternal(cursor);
            boolean bl = isDataNode = TreeNode.layerType(cursor) == 0;
        } while (cursor.shouldRetry());
        if (isInternal) {
            do {
                leftmostSibling = this.treeNode(isDataNode).childAt(cursor, 0, this.stableGeneration, this.unstableGeneration);
            } while (cursor.shouldRetry());
            TreeNode.goTo(cursor, "child", leftmostSibling);
        }
        return isInternal;
    }

    private void visitLevel(PageCursor cursor, GBPTreeVisitor<ROOT_KEY, DATA_KEY, DATA_VALUE> visitor, CursorContext cursorContext) throws IOException {
        long rightSibling;
        do {
            this.visitTreeNode(cursor, visitor, cursorContext);
            do {
                rightSibling = TreeNode.rightSibling(cursor, this.stableGeneration, this.unstableGeneration);
            } while (cursor.shouldRetry());
            if (!TreeNode.isNode(rightSibling)) continue;
            TreeNode.goTo(cursor, "right sibling", rightSibling);
        } while (TreeNode.isNode(rightSibling));
    }
}

