/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageCursorUtil;

class GenerationSafePointer {
    private static final int EMPTY_POINTER = 0;
    static final int EMPTY_GENERATION = 0;
    static final long MIN_GENERATION = 1L;
    static final long FIRST_STABLE_GENERATION = 1L;
    static final long FIRST_UNSTABLE_GENERATION = 3L;
    static final long MAX_GENERATION = 0xFFFFFFFFL;
    static final long GENERATION_MASK = 0xFFFFFFFFL;
    static final long MIN_POINTER = 3L;
    static final long MAX_POINTER = 0xFFFFFFFFFFFFL;
    static final int UNSIGNED_SHORT_MASK = 65535;
    static final int GENERATION_SIZE = 4;
    static final int POINTER_SIZE = 6;
    static final int CHECKSUM_SIZE = 2;
    static final int SIZE = 12;

    private GenerationSafePointer() {
    }

    static void write(PageCursor cursor, long generation, long pointer) {
        GenerationSafePointer.assertGenerationOnWrite(generation);
        GenerationSafePointer.assertPointerOnWrite(pointer);
        GenerationSafePointer.writeGSP(cursor, generation, pointer);
    }

    private static void writeGSP(PageCursor cursor, long generation, long pointer) {
        cursor.putInt((int)generation);
        PageCursorUtil.put6BLong((PageCursor)cursor, (long)pointer);
        cursor.putShort(GenerationSafePointer.checksumOf(generation, pointer));
    }

    static void clean(PageCursor cursor) {
        GenerationSafePointer.writeGSP(cursor, 0L, 0L);
    }

    static void assertGenerationOnWrite(long generation) {
        if (generation < 1L || generation > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Can not write pointer with generation " + generation + " because outside boundary for valid generation.");
        }
    }

    private static void assertPointerOnWrite(long pointer) {
        if ((pointer > 0xFFFFFFFFFFFFL || pointer < 3L) && TreeNode.isNode(pointer)) {
            throw new IllegalArgumentException("Can not write pointer " + pointer + " because outside boundary for valid pointer");
        }
    }

    static long readGeneration(PageCursor cursor) {
        return PageCursorUtil.getUnsignedInt((PageCursor)cursor);
    }

    static long readPointer(PageCursor cursor) {
        return PageCursorUtil.get6BLong((PageCursor)cursor);
    }

    static short readChecksum(PageCursor cursor) {
        return cursor.getShort();
    }

    static boolean verifyChecksum(PageCursor cursor, long generation, long pointer) {
        short checksum = cursor.getShort();
        return checksum == GenerationSafePointer.checksumOf(generation, pointer);
    }

    static short checksumOf(long generation, long pointer) {
        short result = 0;
        result = (short)(result ^ (short)generation & 0xFFFF);
        result = (short)(result ^ (short)(generation >>> 16) & 0xFFFF);
        result = (short)(result ^ (short)pointer & 0xFFFF);
        result = (short)(result ^ (short)(pointer >>> 16) & 0xFFFF);
        result = (short)(result ^ (short)(pointer >>> 32) & 0xFFFF);
        return result;
    }

    public static boolean isEmpty(long generation, long pointer) {
        return generation == 0L && pointer == 0L;
    }

    static String toString(long generation, long pointer, short checksum, boolean correctChecksum) {
        return String.format("GSP[generation=%d, pointer=%d, checksum=%s]", generation, pointer, checksum + (correctChecksum ? "(OK)" : "(NOT OK)"));
    }
}

