/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.HeapScopedBuffer;
import org.neo4j.io.pagecache.impl.BlockSwapper;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.memory.MemoryTracker;

final class FallbackBlockSwapper
implements BlockSwapper {
    private final MemoryTracker memoryTracker;

    FallbackBlockSwapper(MemoryTracker memoryTracker) {
        this.memoryTracker = memoryTracker;
    }

    @Override
    public int swapIn(StoreChannel channel, long bufferAddress, long fileOffset, int bufferSize) throws IOException {
        int readTotal = 0;
        HeapScopedBuffer scopedBuffer = new HeapScopedBuffer(bufferSize, ByteOrder.LITTLE_ENDIAN, this.memoryTracker);
        try {
            int read;
            ByteBuffer buffer = scopedBuffer.getBuffer();
            while ((read = channel.read(buffer, fileOffset + (long)readTotal)) != -1 && (readTotal += read) < bufferSize) {
            }
            buffer.flip();
            for (int i = 0; i < readTotal; ++i) {
                byte b = buffer.get();
                UnsafeUtil.putByte((long)(bufferAddress + (long)i), (byte)b);
            }
            int rest = bufferSize - readTotal;
            if (rest > 0) {
                UnsafeUtil.setMemory((long)(bufferAddress + (long)readTotal), (long)rest, (byte)MuninnPageCache.ZERO_BYTE);
            }
            int n = readTotal;
            scopedBuffer.close();
            return n;
        }
        catch (Throwable throwable) {
            try {
                try {
                    scopedBuffer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new IOException(FallbackBlockSwapper.formatSwapInErrorMessage(fileOffset, bufferSize, readTotal), e);
            }
        }
    }

    private static String formatSwapInErrorMessage(long fileOffset, int size, int readTotal) {
        return "Read failed after " + readTotal + " of " + size + " bytes from fileOffset " + fileOffset + ".";
    }

    @Override
    public void swapOut(StoreChannel channel, long bufferAddress, long fileOffset, int bufferLength) throws IOException {
        try (HeapScopedBuffer scopedBuffer = new HeapScopedBuffer(bufferLength, ByteOrder.LITTLE_ENDIAN, this.memoryTracker);){
            ByteBuffer buffer = scopedBuffer.getBuffer();
            for (int i = 0; i < bufferLength; ++i) {
                byte b = UnsafeUtil.getByte((long)(bufferAddress + (long)i));
                buffer.put(b);
            }
            buffer.flip();
            channel.writeAll(buffer, fileOffset);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }
}

