/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jmx.impl;

import java.util.Date;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.neo4j.jmx.Kernel;
import org.neo4j.jmx.impl.ManagementSupport;
import org.neo4j.jmx.impl.Neo4jMBean;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.kernel.internal.KernelData;
import org.neo4j.storageengine.api.StoreId;

@Deprecated
public class KernelBean
extends Neo4jMBean
implements Kernel {
    private final long kernelStartTime;
    private final String kernelVersion;
    private final ObjectName query;
    private final String instanceId;
    private boolean isReadOnly;
    private long storeCreationDate = -1L;
    private long storeId = -1L;
    private String databaseName;
    private long storeLogVersion;

    KernelBean(KernelData kernel, DataSourceManager dataSourceManager, ManagementSupport support) throws NotCompliantMBeanException {
        super(Kernel.class, kernel, support);
        dataSourceManager.addListener((DataSourceManager.Listener)new DataSourceInfo());
        this.kernelVersion = kernel.version().toString();
        this.instanceId = kernel.instanceId();
        this.query = support.createMBeanQuery(this.instanceId);
        this.kernelStartTime = new Date().getTime();
    }

    String getInstanceId() {
        return this.instanceId;
    }

    @Override
    public ObjectName getMBeanQuery() {
        return this.query;
    }

    @Override
    public Date getKernelStartTime() {
        return new Date(this.kernelStartTime);
    }

    @Override
    public Date getStoreCreationDate() {
        return new Date(this.storeCreationDate);
    }

    @Override
    public String getStoreId() {
        return Long.toHexString(this.storeId);
    }

    @Override
    public long getStoreLogVersion() {
        return this.storeLogVersion;
    }

    @Override
    public String getKernelVersion() {
        return this.kernelVersion;
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    private class DataSourceInfo
    implements DataSourceManager.Listener {
        private DataSourceInfo() {
        }

        public void registered(NeoStoreDataSource ds) {
            StoreId id = ds.getStoreId();
            KernelBean.this.storeLogVersion = ((LogVersionRepository)ds.getDependencyResolver().resolveDependency(LogVersionRepository.class)).getCurrentLogVersion();
            KernelBean.this.storeCreationDate = id.getCreationTime();
            KernelBean.this.isReadOnly = ds.isReadOnly();
            KernelBean.this.storeId = id.getRandomId();
            KernelBean.this.databaseName = ds.getDatabaseName();
        }

        public void unregistered(NeoStoreDataSource ds) {
            KernelBean.this.storeCreationDate = -1L;
            KernelBean.this.storeLogVersion = -1L;
            KernelBean.this.isReadOnly = false;
            KernelBean.this.storeId = -1L;
        }
    }
}

