/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;

public class Indexes {
    public static void awaitResampling(SchemaRead schemaRead, long timeout) throws TimeoutException {
        Iterator<IndexReference> indexes = schemaRead.indexesGetAll();
        Register.DoubleLongRegister register = Registers.newDoubleLongRegister();
        long t0 = System.currentTimeMillis();
        long timeoutMillis = 1000L * timeout;
        while (indexes.hasNext()) {
            IndexReference index = indexes.next();
            try {
                long readUpdates;
                long updateCount = readUpdates = Indexes.readUpdates(index, schemaRead, register);
                boolean hasTimedOut = false;
                while (updateCount > 0L && updateCount <= readUpdates && !hasTimedOut) {
                    Thread.sleep(10L);
                    hasTimedOut = System.currentTimeMillis() - t0 >= timeoutMillis;
                    updateCount = Math.max(updateCount, readUpdates);
                    readUpdates = Indexes.readUpdates(index, schemaRead, register);
                }
                if (!hasTimedOut) continue;
                throw new TimeoutException(String.format("Indexes were not resampled within %s %s", new Object[]{timeout, TimeUnit.SECONDS}));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (IndexNotFoundKernelException e) {
                throw new ConcurrentModificationException("Index was dropped while awaiting resampling", e);
            }
        }
    }

    private static long readUpdates(IndexReference index, SchemaRead schemaRead, Register.DoubleLongRegister register) throws IndexNotFoundKernelException {
        schemaRead.indexUpdatesAndSize(index, register);
        return register.readFirst();
    }
}

