/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Iterator;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationKernelException;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.exceptions.schema.UnableToValidateConstraintKernelException;
import org.neo4j.kernel.api.exceptions.schema.UniqueConstraintViolationKernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.LockHolder;
import org.neo4j.kernel.impl.api.ReleasableLock;
import org.neo4j.kernel.impl.api.operations.EntityOperations;
import org.neo4j.kernel.impl.api.operations.EntityReadOperations;
import org.neo4j.kernel.impl.api.operations.EntityWriteOperations;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.util.PrimitiveIntIterator;
import org.neo4j.kernel.impl.util.PrimitiveLongIterator;

public class ConstraintEnforcingEntityOperations
implements EntityOperations {
    private final EntityWriteOperations entityWriteOperations;
    private final EntityReadOperations entityReadOperations;
    private final SchemaReadOperations schemaReadOperations;

    public ConstraintEnforcingEntityOperations(EntityWriteOperations entityWriteOperations, EntityReadOperations entityReadOperations, SchemaReadOperations schemaReadOperations) {
        this.entityWriteOperations = entityWriteOperations;
        this.entityReadOperations = entityReadOperations;
        this.schemaReadOperations = schemaReadOperations;
    }

    @Override
    public boolean nodeAddLabel(KernelStatement state, long nodeId, int labelId) throws EntityNotFoundException, ConstraintValidationKernelException {
        Iterator<UniquenessConstraint> constraints = this.schemaReadOperations.constraintsGetForLabel(state, labelId);
        while (constraints.hasNext()) {
            UniquenessConstraint constraint = constraints.next();
            int propertyKeyId = constraint.propertyKeyId();
            Property property = this.entityReadOperations.nodeGetProperty(state, nodeId, propertyKeyId);
            if (!property.isDefined()) continue;
            this.validateNoExistingNodeWithLabelAndProperty(state, labelId, (DefinedProperty)property, nodeId);
        }
        return this.entityWriteOperations.nodeAddLabel(state, nodeId, labelId);
    }

    @Override
    public Property nodeSetProperty(KernelStatement state, long nodeId, DefinedProperty property) throws EntityNotFoundException, ConstraintValidationKernelException {
        PrimitiveIntIterator labelIds = this.entityReadOperations.nodeGetLabels(state, nodeId);
        while (labelIds.hasNext()) {
            int propertyKeyId;
            int labelId = labelIds.next();
            Iterator<UniquenessConstraint> constraintIterator = this.schemaReadOperations.constraintsGetForLabelAndPropertyKey(state, labelId, propertyKeyId = property.propertyKeyId());
            if (!constraintIterator.hasNext()) continue;
            this.validateNoExistingNodeWithLabelAndProperty(state, labelId, property, nodeId);
        }
        return this.entityWriteOperations.nodeSetProperty(state, nodeId, property);
    }

    private void validateNoExistingNodeWithLabelAndProperty(KernelStatement state, int labelId, DefinedProperty property, long modifiedNode) throws ConstraintValidationKernelException {
        try {
            Object value = property.value();
            IndexDescriptor indexDescriptor = new IndexDescriptor(labelId, property.propertyKeyId());
            this.assertIndexOnline(state, indexDescriptor);
            state.locks().acquireIndexEntryWriteLock(labelId, property.propertyKeyId(), property.valueAsString());
            PrimitiveLongIterator existingNodes = this.entityReadOperations.nodesGetFromIndexLookup(state, indexDescriptor, value);
            while (existingNodes.hasNext()) {
                long existingNode = existingNodes.next();
                if (existingNode == modifiedNode) continue;
                throw new UniqueConstraintViolationKernelException(labelId, property.propertyKeyId(), value, existingNode);
            }
        }
        catch (IndexNotFoundKernelException | IndexBrokenKernelException e) {
            throw new UnableToValidateConstraintKernelException(e);
        }
    }

    private void assertIndexOnline(KernelStatement state, IndexDescriptor indexDescriptor) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        switch (this.schemaReadOperations.indexGetState(state, indexDescriptor)) {
            case ONLINE: {
                return;
            }
        }
        throw new IndexBrokenKernelException(this.schemaReadOperations.indexGetFailure(state, indexDescriptor));
    }

    @Override
    public void nodeDelete(KernelStatement state, long nodeId) {
        this.entityWriteOperations.nodeDelete(state, nodeId);
    }

    @Override
    public void relationshipDelete(KernelStatement state, long relationshipId) {
        this.entityWriteOperations.relationshipDelete(state, relationshipId);
    }

    @Override
    public boolean nodeRemoveLabel(KernelStatement state, long nodeId, int labelId) throws EntityNotFoundException {
        return this.entityWriteOperations.nodeRemoveLabel(state, nodeId, labelId);
    }

    @Override
    public Property relationshipSetProperty(KernelStatement state, long relationshipId, DefinedProperty property) throws EntityNotFoundException {
        return this.entityWriteOperations.relationshipSetProperty(state, relationshipId, property);
    }

    @Override
    public Property graphSetProperty(KernelStatement state, DefinedProperty property) {
        return this.entityWriteOperations.graphSetProperty(state, property);
    }

    @Override
    public Property nodeRemoveProperty(KernelStatement state, long nodeId, int propertyKeyId) throws EntityNotFoundException {
        return this.entityWriteOperations.nodeRemoveProperty(state, nodeId, propertyKeyId);
    }

    @Override
    public Property relationshipRemoveProperty(KernelStatement state, long relationshipId, int propertyKeyId) throws EntityNotFoundException {
        return this.entityWriteOperations.relationshipRemoveProperty(state, relationshipId, propertyKeyId);
    }

    @Override
    public Property graphRemoveProperty(KernelStatement state, int propertyKeyId) {
        return this.entityWriteOperations.graphRemoveProperty(state, propertyKeyId);
    }

    @Override
    public PrimitiveLongIterator nodesGetForLabel(KernelStatement state, int labelId) {
        return this.entityReadOperations.nodesGetForLabel(state, labelId);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexLookup(KernelStatement state, IndexDescriptor index, Object value) throws IndexNotFoundKernelException {
        return this.entityReadOperations.nodesGetFromIndexLookup(state, index, value);
    }

    @Override
    public long nodeGetUniqueFromIndexLookup(KernelStatement state, IndexDescriptor index, Object value) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        this.assertIndexOnline(state, index);
        int labelId = index.getLabelId();
        int propertyKeyId = index.getPropertyKeyId();
        String stringVal = "";
        if (null != value) {
            DefinedProperty property = Property.property(propertyKeyId, value);
            stringVal = property.valueAsString();
        }
        LockHolder holder = state.locks();
        try (ReleasableLock r = holder.getReleasableIndexEntryReadLock(labelId, propertyKeyId, stringVal);){
            long nodeId = this.entityReadOperations.nodeGetUniqueFromIndexLookup(state, index, value);
            if (-1L == nodeId) {
                r.release();
                try (ReleasableLock w = holder.getReleasableIndexEntryWriteLock(labelId, propertyKeyId, stringVal);){
                    nodeId = this.entityReadOperations.nodeGetUniqueFromIndexLookup(state, index, value);
                    if (-1L != nodeId) {
                        holder.getReleasableIndexEntryReadLock(labelId, propertyKeyId, stringVal).registerWithTransaction();
                        w.release();
                    }
                }
            }
            long l = nodeId;
            return l;
        }
    }

    @Override
    public boolean nodeHasLabel(KernelStatement state, long nodeId, int labelId) throws EntityNotFoundException {
        return this.entityReadOperations.nodeHasLabel(state, nodeId, labelId);
    }

    @Override
    public PrimitiveIntIterator nodeGetLabels(KernelStatement state, long nodeId) throws EntityNotFoundException {
        return this.entityReadOperations.nodeGetLabels(state, nodeId);
    }

    @Override
    public Property nodeGetProperty(KernelStatement state, long nodeId, int propertyKeyId) throws EntityNotFoundException {
        return this.entityReadOperations.nodeGetProperty(state, nodeId, propertyKeyId);
    }

    @Override
    public Property relationshipGetProperty(KernelStatement state, long relationshipId, int propertyKeyId) throws EntityNotFoundException {
        return this.entityReadOperations.relationshipGetProperty(state, relationshipId, propertyKeyId);
    }

    @Override
    public Property graphGetProperty(KernelStatement state, int propertyKeyId) {
        return this.entityReadOperations.graphGetProperty(state, propertyKeyId);
    }

    @Override
    public PrimitiveLongIterator nodeGetPropertyKeys(KernelStatement state, long nodeId) throws EntityNotFoundException {
        return this.entityReadOperations.nodeGetPropertyKeys(state, nodeId);
    }

    @Override
    public Iterator<DefinedProperty> nodeGetAllProperties(KernelStatement state, long nodeId) throws EntityNotFoundException {
        return this.entityReadOperations.nodeGetAllProperties(state, nodeId);
    }

    @Override
    public PrimitiveLongIterator relationshipGetPropertyKeys(KernelStatement state, long relationshipId) throws EntityNotFoundException {
        return this.entityReadOperations.relationshipGetPropertyKeys(state, relationshipId);
    }

    @Override
    public Iterator<DefinedProperty> relationshipGetAllProperties(KernelStatement state, long relationshipId) throws EntityNotFoundException {
        return this.entityReadOperations.relationshipGetAllProperties(state, relationshipId);
    }

    @Override
    public PrimitiveLongIterator graphGetPropertyKeys(KernelStatement state) {
        return this.entityReadOperations.graphGetPropertyKeys(state);
    }

    @Override
    public Iterator<DefinedProperty> graphGetAllProperties(KernelStatement state) {
        return this.entityReadOperations.graphGetAllProperties(state);
    }
}

