/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.impl.api.operations.EntityReadOperations;
import org.neo4j.kernel.impl.api.operations.EntityWriteOperations;
import org.neo4j.kernel.impl.api.operations.KeyReadOperations;
import org.neo4j.kernel.impl.api.operations.KeyWriteOperations;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.operations.SchemaStateOperations;
import org.neo4j.kernel.impl.api.operations.SchemaWriteOperations;

public class StatementOperationParts {
    private final KeyReadOperations keyReadOperations;
    private final KeyWriteOperations keyWriteOperations;
    private final EntityReadOperations entityReadOperations;
    private final EntityWriteOperations entityWriteOperations;
    private final SchemaReadOperations schemaReadOperations;
    private final SchemaWriteOperations schemaWriteOperations;
    private final SchemaStateOperations schemaStateOperations;
    private Map<Class, Object> additionalParts;

    public StatementOperationParts(KeyReadOperations keyReadOperations, KeyWriteOperations keyWriteOperations, EntityReadOperations entityReadOperations, EntityWriteOperations entityWriteOperations, SchemaReadOperations schemaReadOperations, SchemaWriteOperations schemaWriteOperations, SchemaStateOperations schemaStateOperations) {
        this.keyReadOperations = keyReadOperations;
        this.keyWriteOperations = keyWriteOperations;
        this.entityReadOperations = entityReadOperations;
        this.entityWriteOperations = entityWriteOperations;
        this.schemaReadOperations = schemaReadOperations;
        this.schemaWriteOperations = schemaWriteOperations;
        this.schemaStateOperations = schemaStateOperations;
    }

    public <T> StatementOperationParts additionalPart(Class<T> cls, T value) {
        if (this.additionalParts == null) {
            this.additionalParts = new HashMap<Class, Object>();
        }
        this.additionalParts.put(cls, value);
        return this;
    }

    public <T> T resolve(Class<T> cls) {
        Object part;
        Object object = part = this.additionalParts != null ? this.additionalParts.get(cls) : null;
        if (part == null) {
            throw new IllegalArgumentException("No part " + cls.getName());
        }
        return (T)part;
    }

    public KeyReadOperations keyReadOperations() {
        return this.checkNotNull(this.keyReadOperations, KeyReadOperations.class);
    }

    public KeyWriteOperations keyWriteOperations() {
        return this.checkNotNull(this.keyWriteOperations, KeyWriteOperations.class);
    }

    public EntityReadOperations entityReadOperations() {
        return this.checkNotNull(this.entityReadOperations, EntityReadOperations.class);
    }

    public EntityWriteOperations entityWriteOperations() {
        return this.checkNotNull(this.entityWriteOperations, EntityWriteOperations.class);
    }

    public SchemaReadOperations schemaReadOperations() {
        return this.checkNotNull(this.schemaReadOperations, SchemaReadOperations.class);
    }

    public SchemaWriteOperations schemaWriteOperations() {
        return this.checkNotNull(this.schemaWriteOperations, SchemaWriteOperations.class);
    }

    public SchemaStateOperations schemaStateOperations() {
        return this.checkNotNull(this.schemaStateOperations, SchemaStateOperations.class);
    }

    public StatementOperationParts override(KeyReadOperations keyReadOperations, KeyWriteOperations keyWriteOperations, EntityReadOperations entityReadOperations, EntityWriteOperations entityWriteOperations, SchemaReadOperations schemaReadOperations, SchemaWriteOperations schemaWriteOperations, SchemaStateOperations schemaStateOperations, Object ... alternatingAdditionalClassAndObject) {
        StatementOperationParts parts = new StatementOperationParts(this.eitherOr(keyReadOperations, this.keyReadOperations, KeyReadOperations.class), this.eitherOr(keyWriteOperations, this.keyWriteOperations, KeyWriteOperations.class), this.eitherOr(entityReadOperations, this.entityReadOperations, EntityReadOperations.class), this.eitherOr(entityWriteOperations, this.entityWriteOperations, EntityWriteOperations.class), this.eitherOr(schemaReadOperations, this.schemaReadOperations, SchemaReadOperations.class), this.eitherOr(schemaWriteOperations, this.schemaWriteOperations, SchemaWriteOperations.class), this.eitherOr(schemaStateOperations, this.schemaStateOperations, SchemaStateOperations.class));
        if (this.additionalParts != null) {
            parts.additionalParts = new HashMap<Class, Object>(this.additionalParts);
        }
        for (int i = 0; i < alternatingAdditionalClassAndObject.length; ++i) {
            parts.additionalPart((Class)alternatingAdditionalClassAndObject[i++], alternatingAdditionalClassAndObject[i]);
        }
        return parts;
    }

    private <T> T checkNotNull(T object, Class<T> cls) {
        if (object == null) {
            throw new IllegalStateException("No part of type " + cls.getSimpleName() + " assigned");
        }
        return object;
    }

    private <T> T eitherOr(T first, T other, Class<T> cls) {
        return first != null ? first : other;
    }
}

