/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Map;
import org.neo4j.kernel.impl.index.IndexDefineCommand;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;

public abstract class IndexCommand
extends XaCommand {
    static final byte DEFINE_COMMAND = 0;
    static final byte ADD_COMMAND = 1;
    static final byte ADD_RELATIONSHIP_COMMAND = 2;
    static final byte REMOVE_COMMAND = 3;
    static final byte DELETE_COMMAND = 4;
    static final byte CREATE_COMMAND = 5;
    public static final byte NODE = 0;
    public static final byte RELATIONSHIP = 1;
    private static final byte VALUE_TYPE_NULL = 0;
    private static final byte VALUE_TYPE_SHORT = 1;
    private static final byte VALUE_TYPE_INT = 2;
    private static final byte VALUE_TYPE_LONG = 3;
    private static final byte VALUE_TYPE_FLOAT = 4;
    private static final byte VALUE_TYPE_DOUBLE = 5;
    private static final byte VALUE_TYPE_STRING = 6;
    private final byte commandType;
    private final byte indexNameId;
    private final byte entityType;
    private final long entityId;
    private final byte keyId;
    private final byte valueType;
    private final Object value;

    IndexCommand(byte commandType, byte indexNameId, byte entityType, long entityId, byte keyId, Object value) {
        this.commandType = commandType;
        this.indexNameId = indexNameId;
        this.entityType = entityType;
        this.entityId = entityId;
        this.keyId = keyId;
        this.value = value;
        this.valueType = IndexCommand.valueTypeOf(value);
    }

    public byte getIndexNameId() {
        return this.indexNameId;
    }

    public byte getEntityType() {
        return this.entityType;
    }

    public long getEntityId() {
        return this.entityId;
    }

    public byte getKeyId() {
        return this.keyId;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public void execute() {
    }

    @Override
    public void writeToFile(LogBuffer buffer) throws IOException {
        this.writeHeader(buffer);
        IndexCommand.putIntOrLong(buffer, this.entityId);
        switch (this.valueType) {
            case 6: {
                IoPrimitiveUtils.write3bLengthAndString(buffer, this.value.toString());
                break;
            }
            case 1: {
                buffer.putShort(((Number)this.value).shortValue());
                break;
            }
            case 2: {
                buffer.putInt(((Number)this.value).intValue());
                break;
            }
            case 3: {
                buffer.putLong(((Number)this.value).longValue());
                break;
            }
            case 4: {
                buffer.putFloat(((Number)this.value).floatValue());
                break;
            }
            case 5: {
                buffer.putDouble(((Number)this.value).doubleValue());
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown value type " + this.valueType);
            }
        }
    }

    protected void writeHeader(LogBuffer buffer) throws IOException {
        buffer.put((byte)(this.commandType << 5 | this.valueType << 2 | this.entityType << 1 | IndexCommand.needsLong(this.entityId)));
        buffer.put((byte)(this.startNodeNeedsLong() << 7 | this.endNodeNeedsLong() << 6 | this.indexNameId));
        buffer.put(this.keyId);
    }

    protected static void putIntOrLong(LogBuffer buffer, long id) throws IOException {
        if (IndexCommand.needsLong(id) == 1) {
            buffer.putLong(id);
        } else {
            buffer.putInt((int)id);
        }
    }

    protected static byte needsLong(long value) {
        return value > Integer.MAX_VALUE ? (byte)1 : 0;
    }

    protected byte startNodeNeedsLong() {
        return 0;
    }

    protected byte endNodeNeedsLong() {
        return 0;
    }

    private static byte valueTypeOf(Object value) {
        int valueType = 0;
        valueType = value == null ? 0 : (value instanceof Number ? (value instanceof Float ? 4 : (value instanceof Double ? 5 : (value instanceof Long ? 3 : (value instanceof Short ? 1 : 2)))) : 6);
        return (byte)valueType;
    }

    public boolean isConsideredNormalWriteCommand() {
        return true;
    }

    private static Object readValue(byte valueType, ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        switch (valueType) {
            case 0: {
                return null;
            }
            case 1: {
                return IoPrimitiveUtils.readShort(channel, buffer);
            }
            case 2: {
                return IoPrimitiveUtils.readInt(channel, buffer);
            }
            case 3: {
                return IoPrimitiveUtils.readLong(channel, buffer);
            }
            case 4: {
                return IoPrimitiveUtils.readFloat(channel, buffer);
            }
            case 5: {
                return IoPrimitiveUtils.readDouble(channel, buffer);
            }
            case 6: {
                return IoPrimitiveUtils.read3bLengthAndString(channel, buffer);
            }
        }
        throw new RuntimeException("Unknown value type " + valueType);
    }

    public static XaCommand readCommand(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        byte[] headerBytes = IoPrimitiveUtils.readBytes(channel, new byte[3]);
        if (headerBytes == null) {
            return null;
        }
        byte commandType = (byte)((headerBytes[0] & 0xE0) >> 5);
        byte valueType = (byte)((headerBytes[0] & 0x1C) >> 2);
        byte entityType = (byte)((headerBytes[0] & 2) >> 1);
        boolean entityIdNeedsLong = (headerBytes[0] & 1) > 0;
        byte indexNameId = (byte)(headerBytes[1] & 0x3F);
        byte keyId = headerBytes[2];
        switch (commandType) {
            case 0: {
                Map<String, Byte> indexNames = IndexDefineCommand.readMap(channel, buffer);
                Map<String, Byte> keys = IndexDefineCommand.readMap(channel, buffer);
                if (indexNames == null || keys == null) {
                    return null;
                }
                return new IndexDefineCommand(indexNames, keys);
            }
            case 5: {
                Map<String, String> config = IoPrimitiveUtils.read2bMap(channel, buffer);
                if (config == null) {
                    return null;
                }
                return new CreateCommand(indexNameId, entityType, config);
            }
            case 4: {
                return new DeleteCommand(indexNameId, entityType);
            }
            case 1: 
            case 2: 
            case 3: {
                Number endNode;
                Number entityId;
                Number number = entityId = entityIdNeedsLong ? (Number)IoPrimitiveUtils.readLong(channel, buffer) : (Number)IoPrimitiveUtils.readInt(channel, buffer);
                if (entityId == null) {
                    return null;
                }
                Object value = IndexCommand.readValue(valueType, channel, buffer);
                if (valueType != 0 && value == null) {
                    return null;
                }
                if (commandType == 1) {
                    return new AddCommand(indexNameId, entityType, entityId.longValue(), keyId, value);
                }
                if (commandType == 3) {
                    return new RemoveCommand(indexNameId, entityType, entityId.longValue(), keyId, value);
                }
                boolean startNodeNeedsLong = (headerBytes[1] & 8) > 0;
                boolean endNodeNeedsLong = (headerBytes[1] & 0x40) > 0;
                Number startNode = startNodeNeedsLong ? (Number)IoPrimitiveUtils.readLong(channel, buffer) : (Number)IoPrimitiveUtils.readInt(channel, buffer);
                Number number2 = endNode = endNodeNeedsLong ? (Number)IoPrimitiveUtils.readLong(channel, buffer) : (Number)IoPrimitiveUtils.readInt(channel, buffer);
                if (startNode == null || endNode == null) {
                    return null;
                }
                return new AddRelationshipCommand(indexNameId, entityType, entityId.longValue(), keyId, value, startNode.longValue(), endNode.longValue());
            }
        }
        throw new RuntimeException("Unknown command type " + commandType);
    }

    public boolean equals(Object obj) {
        boolean equals;
        IndexCommand other = (IndexCommand)obj;
        boolean bl = equals = this.commandType == other.commandType && this.entityType == other.entityType && this.indexNameId == other.indexNameId && this.keyId == other.keyId && this.valueType == other.valueType;
        if (!equals) {
            return false;
        }
        return this.value == null ? other.value == null : this.value.equals(other.value);
    }

    public static class CreateCommand
    extends IndexCommand {
        private final Map<String, String> config;

        CreateCommand(byte indexNameId, byte entityType, Map<String, String> config) {
            super((byte)5, indexNameId, entityType, 0L, (byte)0, null);
            this.config = config;
        }

        public Map<String, String> getConfig() {
            return this.config;
        }

        @Override
        public void writeToFile(LogBuffer buffer) throws IOException {
            this.writeHeader(buffer);
            buffer.putShort((short)this.config.size());
            for (Map.Entry<String, String> entry : this.config.entrySet()) {
                IoPrimitiveUtils.write2bLengthAndString(buffer, entry.getKey());
                IoPrimitiveUtils.write2bLengthAndString(buffer, entry.getValue());
            }
        }

        @Override
        public boolean isConsideredNormalWriteCommand() {
            return false;
        }

        public int hashCode() {
            return this.config != null ? this.config.hashCode() : 0;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && this.config.equals(((CreateCommand)obj).config);
        }
    }

    public static class DeleteCommand
    extends IndexCommand {
        DeleteCommand(byte indexNameId, byte entityType) {
            super((byte)4, indexNameId, entityType, 0L, (byte)0, null);
        }

        @Override
        public void writeToFile(LogBuffer buffer) throws IOException {
            this.writeHeader(buffer);
        }

        @Override
        public boolean isConsideredNormalWriteCommand() {
            return false;
        }
    }

    public static class RemoveCommand
    extends IndexCommand {
        RemoveCommand(byte indexNameId, byte entityType, long entityId, byte keyId, Object value) {
            super((byte)3, indexNameId, entityType, entityId, keyId, value);
        }
    }

    public static class AddRelationshipCommand
    extends IndexCommand {
        private final long startNode;
        private final long endNode;

        AddRelationshipCommand(byte indexNameId, byte entityType, long entityId, byte keyId, Object value, long startNode, long endNode) {
            super((byte)2, indexNameId, entityType, entityId, keyId, value);
            this.startNode = startNode;
            this.endNode = endNode;
        }

        public long getStartNode() {
            return this.startNode;
        }

        public long getEndNode() {
            return this.endNode;
        }

        @Override
        protected byte startNodeNeedsLong() {
            return AddRelationshipCommand.needsLong(this.startNode);
        }

        @Override
        protected byte endNodeNeedsLong() {
            return AddRelationshipCommand.needsLong(this.endNode);
        }

        @Override
        public void writeToFile(LogBuffer buffer) throws IOException {
            super.writeToFile(buffer);
            AddRelationshipCommand.putIntOrLong(buffer, this.startNode);
            AddRelationshipCommand.putIntOrLong(buffer, this.endNode);
        }

        public int hashCode() {
            int result = (int)(this.startNode ^ this.startNode >>> 32);
            result = 31 * result + (int)(this.endNode ^ this.endNode >>> 32);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            AddRelationshipCommand other = (AddRelationshipCommand)obj;
            return this.startNode == other.startNode && this.endNode == other.endNode;
        }
    }

    public static class AddCommand
    extends IndexCommand {
        AddCommand(byte indexNameId, byte entityType, long entityId, byte keyId, Object value) {
            super((byte)1, indexNameId, entityType, entityId, keyId, value);
        }
    }
}

