/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.util.CopyOnWriteAfterIteratorHashSet;
import org.neo4j.kernel.impl.util.DiffApplyingPrimitiveIntIterator;
import org.neo4j.kernel.impl.util.DiffApplyingPrimitiveLongIterator;
import org.neo4j.kernel.impl.util.PrimitiveIntIterator;
import org.neo4j.kernel.impl.util.PrimitiveLongIterator;

public class DiffSets<T> {
    private static final DiffSets EMPTY = new DiffSets(Collections.emptySet(), Collections.emptySet()){

        public Iterator apply(Iterator source) {
            return source;
        }
    };
    private Set<T> addedElements;
    private Set<T> removedElements;
    private Predicate<T> filter;

    public static <T> DiffSets<T> emptyDiffSets() {
        return EMPTY;
    }

    public DiffSets() {
        this(null, null);
    }

    public DiffSets(Set<T> addedElements, Set<T> removedElements) {
        this.addedElements = addedElements;
        this.removedElements = removedElements;
    }

    public void accept(Visitor<T> visitor) {
        for (T element : this.added(false)) {
            visitor.visitAdded(element);
        }
        for (T element : this.removed(false)) {
            visitor.visitRemoved(element);
        }
    }

    public boolean add(T elem) {
        boolean result = this.added(true).add(elem);
        this.removed(false).remove(elem);
        return result;
    }

    public void replace(T toRemove, T toAdd) {
        Set<T> added = this.added(true);
        boolean removedFromAdded = added.remove(toRemove);
        this.removed(false).remove(toAdd);
        added.add(toAdd);
        if (!removedFromAdded) {
            this.removed(true).add(toRemove);
        }
    }

    public boolean remove(T elem) {
        boolean removedFromAddedElements = this.added(false).remove(elem);
        return removedFromAddedElements || this.removed(true).add(elem);
    }

    public void addAll(Iterator<T> elems) {
        while (elems.hasNext()) {
            this.add(elems.next());
        }
    }

    public void removeAll(Iterator<T> elems) {
        while (elems.hasNext()) {
            this.remove(elems.next());
        }
    }

    public boolean isAdded(T elem) {
        return this.added(false).contains(elem);
    }

    public boolean isRemoved(T elem) {
        return this.removed(false).contains(elem);
    }

    public Set<T> getAdded() {
        return this.resultSet(this.addedElements);
    }

    public Set<T> getRemoved() {
        return this.resultSet(this.removedElements);
    }

    public boolean isEmpty() {
        return this.added(false).isEmpty() && this.removed(false).isEmpty();
    }

    public Iterator<T> apply(Iterator<T> source) {
        Iterator<T> result = source;
        if (this.removedElements != null && !this.removedElements.isEmpty() || this.addedElements != null && !this.addedElements.isEmpty()) {
            this.ensureFilterHasBeenCreated();
            result = Iterables.filter(this.filter, result);
        }
        if (this.addedElements != null && !this.addedElements.isEmpty()) {
            result = Iterables.concat(result, this.addedElements.iterator());
        }
        return result;
    }

    public PrimitiveLongIterator applyPrimitiveLongIterator(PrimitiveLongIterator source) {
        return new DiffApplyingPrimitiveLongIterator(source, this.added(false), this.removed(false));
    }

    public PrimitiveIntIterator applyPrimitiveIntIterator(PrimitiveIntIterator source) {
        return new DiffApplyingPrimitiveIntIterator(source, this.added(false), this.removed(false));
    }

    public DiffSets<T> filterAdded(Predicate<T> addedFilter) {
        return new DiffSets<T>(IteratorUtil.asSet(Iterables.filter(addedFilter, this.added(false))), IteratorUtil.asSet(this.removed(false)));
    }

    public DiffSets<T> filter(Predicate<T> filter) {
        return new DiffSets<T>(IteratorUtil.asSet(Iterables.filter(filter, this.added(false))), IteratorUtil.asSet(Iterables.filter(filter, this.removed(false))));
    }

    private Set<T> added(boolean create) {
        if (this.addedElements == null) {
            if (!create) {
                return Collections.emptySet();
            }
            this.addedElements = this.newSet();
        }
        return this.addedElements;
    }

    private Set<T> removed(boolean create) {
        if (this.removedElements == null) {
            if (!create) {
                return Collections.emptySet();
            }
            this.removedElements = this.newSet();
        }
        return this.removedElements;
    }

    private void ensureFilterHasBeenCreated() {
        if (this.filter == null) {
            this.filter = new Predicate<T>(){

                @Override
                public boolean accept(T item) {
                    return !DiffSets.this.removed(false).contains(item) && !DiffSets.this.added(false).contains(item);
                }
            };
        }
    }

    public int delta() {
        return this.added(false).size() - this.removed(false).size();
    }

    private Set<T> newSet() {
        return new CopyOnWriteAfterIteratorHashSet();
    }

    private Set<T> resultSet(Set<T> coll) {
        return coll == null ? Collections.emptySet() : Collections.unmodifiableSet(coll);
    }

    public boolean unRemove(T item) {
        return this.removed(false).remove(item);
    }

    public String toString() {
        return String.format("{+%s, -%s}", this.added(false), this.removed(false));
    }

    public static interface Visitor<T> {
        public void visitAdded(T var1);

        public void visitRemoved(T var1);
    }
}

