/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Resource;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.util.DependencySatisfier;
import org.neo4j.kernel.impl.util.UnsatisfiedDependencyException;

public interface StoreMigrationParticipant
extends Resource {
    public static final StoreMigrationParticipant NOT_PARTICIPATING = new Adapter(){

        @Override
        public boolean needsMigration(FileSystemAbstraction fileSystem, File sourceStoreDir) throws IOException {
            return false;
        }

        @Override
        public void migrate(FileSystemAbstraction fileSystem, File sourceStoreDir, File targetStoreDir, DependencyResolver dependencies) throws IOException, UnsatisfiedDependencyException {
            throw new UnsupportedOperationException("Should not have been called");
        }

        @Override
        public void moveMigratedFiles(FileSystemAbstraction fileSystem, File migrationDirectory, File workingDirectory, File leftOversDirectory) throws IOException {
            throw new UnsupportedOperationException("Should not have been called");
        }
    };

    public boolean needsMigration(FileSystemAbstraction var1, File var2) throws IOException;

    public void migrate(FileSystemAbstraction var1, File var2, File var3, DependencyResolver var4) throws IOException, UnsatisfiedDependencyException;

    public void satisfyDependenciesDownstream(FileSystemAbstraction var1, File var2, File var3, DependencySatisfier var4, boolean var5);

    public void moveMigratedFiles(FileSystemAbstraction var1, File var2, File var3, File var4) throws IOException;

    @Override
    public void close();

    public void cleanup(FileSystemAbstraction var1, File var2) throws IOException;

    public static abstract class Adapter
    implements StoreMigrationParticipant {
        @Override
        public void close() {
        }

        @Override
        public void cleanup(FileSystemAbstraction fileSystem, File migrationDir) throws IOException {
        }

        @Override
        public void satisfyDependenciesDownstream(FileSystemAbstraction fileSystem, File storeDir, File migrationDir, DependencySatisfier dependencySatisfier, boolean participatedInMigration) {
        }
    }
}

