/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.util.List;
import org.neo4j.helpers.Function;
import org.neo4j.kernel.TransactionInterceptorProviders;
import org.neo4j.kernel.impl.nioneo.xa.command.Command;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInterceptor;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;

public class LogEntryVisitorAdapter
implements Function<List<LogEntry>, List<LogEntry>> {
    private final TransactionInterceptorProviders providers;
    private final XaDataSource ds;

    public LogEntryVisitorAdapter(TransactionInterceptorProviders providers, XaDataSource ds) {
        this.providers = providers;
        this.ds = ds;
    }

    @Override
    public List<LogEntry> apply(List<LogEntry> entries) {
        TransactionInterceptor interceptor = this.providers.resolveChain(this.ds);
        for (LogEntry entry : entries) {
            if (entry instanceof LogEntry.Command) {
                LogEntry.Command commandEntry = (LogEntry.Command)entry;
                if (!(commandEntry.getXaCommand() instanceof Command)) continue;
                ((Command)commandEntry.getXaCommand()).accept(interceptor);
                continue;
            }
            if (entry instanceof LogEntry.Start) {
                interceptor.setStartEntry((LogEntry.Start)entry);
                continue;
            }
            if (!(entry instanceof LogEntry.Commit)) continue;
            interceptor.setCommitEntry((LogEntry.Commit)entry);
        }
        interceptor.complete();
        return entries;
    }
}

