/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.info;

import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.info.DiagnosticsProvider;

public enum DiagnosticsPhase {
    REQUESTED(true, false),
    EXPLICIT(true, false),
    CREATED(false, true),
    INITIALIZED(false, true),
    STARTED(false, true),
    LOG_ROTATION(false, true),
    STOPPING(false, false),
    SHUTDOWN(false, false);

    private final boolean requested;
    private final boolean initial;

    private DiagnosticsPhase(boolean requested, boolean initial) {
        this.requested = requested;
        this.initial = initial;
    }

    void emitStart(StringLogger log) {
        log.info("--- " + (Object)((Object)this) + " START ---");
    }

    void emitDone(StringLogger log) {
        log.info("--- " + (Object)((Object)this) + " END ---");
    }

    void emitStart(StringLogger log, DiagnosticsProvider provider) {
        log.info("--- " + (Object)((Object)this) + " for " + provider.getDiagnosticsIdentifier() + " START ---");
    }

    void emitDone(StringLogger log, DiagnosticsProvider provider) {
        log.info("--- " + (Object)((Object)this) + " for " + provider.getDiagnosticsIdentifier() + " END ---");
    }

    public boolean isInitialization() {
        return this.initial;
    }

    public boolean isExplicitlyRequested() {
        return this.requested;
    }

    public String toString() {
        return this.name() + " diagnostics";
    }
}

