/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPool;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.unsafe.impl.batchimport.store.Monitor;

public class BatchFriendlyWindowPoolFactory
implements WindowPoolFactory {
    private static final ByteBuffer ZEROS = ByteBuffer.allocateDirect(4096);
    public static final WriterFactory SYNCHRONOUS = new WriterFactory(){

        @Override
        public Writer create(File file, final StoreChannel channel, final Monitor monitor) {
            return new Writer(){

                @Override
                public void write(ByteBuffer data, long position) throws IOException {
                    channel.position(position);
                    int written = channel.write(data);
                    monitor.dataWritten(written);
                }
            };
        }
    };
    private final int windowTargetSize;
    private final Monitor monitor;
    private final Mode mode;
    private final WriterFactory writerFactory;

    public BatchFriendlyWindowPoolFactory(int windowTargetSize, Monitor monitor, Mode mode, WriterFactory writerFactory) {
        this.windowTargetSize = windowTargetSize;
        this.monitor = monitor;
        this.mode = mode;
        this.writerFactory = writerFactory;
    }

    @Override
    public WindowPool create(File storageFileName, int recordSize, StoreChannel fileChannel, Config configuration, StringLogger log, int numberOfReservedLowIds) {
        return new SingleWindowPool(storageFileName, recordSize, fileChannel, numberOfReservedLowIds);
    }

    protected SingleWindow createSingleWindow(File storageFileName, int recordSize, StoreChannel channel, int numberOfReservedLowIds) {
        return new SingleWindow(storageFileName, recordSize, channel);
    }

    protected class SingleWindow
    implements PersistenceWindow {
        private final File storageFileName;
        private final int recordSize;
        private final StoreChannel channel;
        private Buffer reusableBuffer;
        private int maxRecordsInBuffer;
        protected long firstIdInWindow;
        protected long lastIdInWindow;
        private final Writer writer;

        protected SingleWindow(File storageFileName, int recordSize, StoreChannel channel) {
            this.storageFileName = storageFileName;
            this.recordSize = recordSize;
            this.channel = channel;
            this.writer = BatchFriendlyWindowPoolFactory.this.writerFactory.create(storageFileName, channel, BatchFriendlyWindowPoolFactory.this.monitor);
        }

        public String toString() {
            return "Batch friendly " + this.getClass().getSimpleName() + " for " + this.storageFileName;
        }

        protected void allocateBuffer() {
            this.reusableBuffer = new Buffer(this, ByteBuffer.allocateDirect(this.roundedToNearestRecordSize(BatchFriendlyWindowPoolFactory.this.windowTargetSize)));
            this.maxRecordsInBuffer = this.reusableBuffer.getBuffer().capacity() / this.recordSize;
        }

        private int roundedToNearestRecordSize(int targetSize) {
            int rest = targetSize % this.recordSize;
            return targetSize - rest;
        }

        protected PersistenceWindow acquire(long id, OperationType operationType) {
            assert (operationType == OperationType.WRITE || operationType == OperationType.READ && BatchFriendlyWindowPoolFactory.this.mode.canReadFrom(this.windowIndex(id)));
            boolean isInCurrentWindow = this.idIsWithinCurrentWindow(id);
            if (!isInCurrentWindow) {
                this.writeBufferToChannel();
                this.placeWindowFor(id);
            }
            return this;
        }

        private void placeWindowFor(long id) {
            long windowIndex = this.windowIndex(id);
            this.firstIdInWindow = windowIndex * (long)this.maxRecordsInBuffer;
            this.lastIdInWindow = this.firstIdInWindow + (long)this.maxRecordsInBuffer - 1L;
            if (BatchFriendlyWindowPoolFactory.this.mode.canReadFrom(windowIndex)) {
                this.readBufferFromChannel();
            } else {
                this.zeroBuffer();
            }
        }

        private void zeroBuffer() {
            ByteBuffer zeros = ZEROS.duplicate();
            this.reusableBuffer.reset();
            ByteBuffer buffer = this.reusableBuffer.getBuffer();
            while (buffer.hasRemaining()) {
                int chunkSize = Math.min(buffer.remaining(), zeros.capacity());
                zeros.clear();
                zeros.limit(chunkSize);
                buffer.put(zeros);
            }
        }

        private long windowIndex(long id) {
            return id / (long)this.maxRecordsInBuffer;
        }

        private boolean idIsWithinCurrentWindow(long id) {
            return id >= this.firstIdInWindow && id <= this.lastIdInWindow;
        }

        @Override
        public Buffer getBuffer() {
            throw new UnsupportedOperationException("Not really needed");
        }

        @Override
        public Buffer getOffsettedBuffer(long id) {
            assert (this.idIsWithinCurrentWindow(id)) : "Quite surprisingly the id " + id + " is outside the current window. At this point acquire should have been called previously" + " with the same id. First id in window " + this.firstIdInWindow + ", last " + this.lastIdInWindow;
            this.reusableBuffer.setOffset((int)((id - this.firstIdInWindow) * (long)this.recordSize));
            return this.reusableBuffer;
        }

        @Override
        public int getRecordSize() {
            return this.recordSize;
        }

        @Override
        public long position() {
            try {
                return this.channel.position();
            }
            catch (IOException e) {
                throw this.handleIoException(e);
            }
        }

        private RuntimeException handleIoException(IOException e) {
            throw new RuntimeException(e);
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException("Not needed");
        }

        @Override
        public void force() {
            this.writeBufferToChannel();
        }

        private void writeBufferToChannel() {
            try {
                this.writer.write(this.prepared(this.reusableBuffer.getBuffer()), this.firstIdInWindow * (long)this.recordSize);
                this.reusableBuffer.reset();
            }
            catch (IOException e) {
                throw this.handleIoException(e);
            }
        }

        private void readBufferFromChannel() {
            try {
                this.channel.position(this.firstIdInWindow * (long)this.recordSize);
                this.channel.read(this.prepared(this.reusableBuffer.getBuffer()));
            }
            catch (IOException e) {
                throw this.handleIoException(e);
            }
        }

        private ByteBuffer prepared(ByteBuffer buffer) {
            buffer.flip();
            buffer.limit((int)((this.lastIdInWindow - this.firstIdInWindow + 1L) * (long)this.recordSize));
            return buffer;
        }

        @Override
        public void close() {
            this.force();
        }
    }

    private class SingleWindowPool
    implements WindowPool {
        private final SingleWindow window;
        private final File storageFileName;

        public SingleWindowPool(File storageFileName, int recordSize, StoreChannel channel, int numberOfReservedLowIds) {
            this.storageFileName = storageFileName;
            this.window = BatchFriendlyWindowPoolFactory.this.createSingleWindow(storageFileName, recordSize, channel, numberOfReservedLowIds);
            this.window.allocateBuffer();
            this.window.placeWindowFor(0L);
        }

        public String toString() {
            return this.storageFileName.getName();
        }

        @Override
        public PersistenceWindow acquire(long position, OperationType operationType) {
            return this.window.acquire(position, operationType);
        }

        @Override
        public void release(PersistenceWindow window) {
        }

        @Override
        public void flushAll() {
        }

        @Override
        public void close() {
            this.window.close();
        }

        @Override
        public WindowPoolStats getStats() {
            return null;
        }
    }

    public static enum Mode {
        APPEND_ONLY{

            @Override
            boolean canReadFrom(long windowIndex) {
                return windowIndex == 0L;
            }
        }
        ,
        UPDATE{

            @Override
            boolean canReadFrom(long windowIndex) {
                return true;
            }
        };


        abstract boolean canReadFrom(long var1);
    }

    public static interface Writer {
        public void write(ByteBuffer var1, long var2) throws IOException;
    }

    public static interface WriterFactory {
        public Writer create(File var1, StoreChannel var2, Monitor var3);
    }
}

