/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking.community;

import org.neo4j.helpers.MathUtil;
import org.neo4j.storageengine.api.lock.ResourceType;

public class LockResource {
    private final ResourceType resourceType;
    private final long resourceId;
    private int refCount = 1;

    public LockResource(ResourceType resourceType, long resourceId) {
        this.resourceType = resourceType;
        this.resourceId = resourceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LockResource that = (LockResource)o;
        return this.resourceId == that.resourceId && this.resourceType.equals(that.resourceType);
    }

    public int hashCode() {
        int result = this.resourceType.hashCode();
        result = 31 * result + (int)(this.resourceId ^ this.resourceId >>> 32);
        return result;
    }

    public String toString() {
        return String.format("%s(%d)", this.resourceType, this.resourceId);
    }

    public void acquireReference() {
        this.refCount = Math.incrementExact(this.refCount);
    }

    public int releaseReference() {
        this.refCount = MathUtil.decrementExactNotPastZero(this.refCount);
        return this.refCount;
    }

    public long resourceId() {
        return this.resourceId;
    }

    public ResourceType type() {
        return this.resourceType;
    }
}

