/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format;

import javax.annotation.Nonnull;

public enum StoreVersion {
    STANDARD_V2_0("v0.A.1", true),
    STANDARD_V2_1("v0.A.3", true),
    STANDARD_V2_2("v0.A.5", true),
    STANDARD_V2_3("v0.A.6", true),
    STANDARD_V3_0("v0.A.7", true),
    HIGH_LIMIT_V3_0_0("vE.H.0", false),
    HIGH_LIMIT_V3_0_6("vE.H.0b", false);

    private static final StoreVersion[] ALL_STORE_VERSIONS;
    private final String versionString;
    private final boolean isCommunity;

    private StoreVersion(String versionString, boolean isCommunity) {
        this.versionString = versionString;
        this.isCommunity = isCommunity;
    }

    public String versionString() {
        return this.versionString;
    }

    public static boolean isCommunityStoreVersion(@Nonnull String version) {
        for (StoreVersion storeVersion : ALL_STORE_VERSIONS) {
            if (!storeVersion.versionString.equals(version) || !storeVersion.isCommunity) continue;
            return true;
        }
        return false;
    }

    public static boolean isEnterpriseStoreVersion(@Nonnull String version) {
        for (StoreVersion storeVersion : ALL_STORE_VERSIONS) {
            if (!storeVersion.versionString.equals(version) || storeVersion.isCommunity) continue;
            return true;
        }
        return false;
    }

    static {
        ALL_STORE_VERSIONS = StoreVersion.values();
    }
}

