/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.impl.api.TransactionQueue;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.Commitment;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.recovery.LatestCheckPointFinder;
import org.neo4j.kernel.recovery.PositionToRecoverFrom;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public class DefaultRecoverySPI
implements Recovery.SPI {
    private final LogVersionRepository logVersionRepository;
    private final PositionToRecoverFrom positionToRecoverFrom;
    private final PhysicalLogFiles logFiles;
    private final FileSystemAbstraction fs;
    private final StorageEngine storageEngine;
    private final TransactionIdStore transactionIdStore;
    private final LogicalTransactionStore logicalTransactionStore;
    private Visitor<CommittedTransactionRepresentation, Exception> recoveryVisitor;
    private TransactionQueue transactionsToApply;

    public DefaultRecoverySPI(StorageEngine storageEngine, PhysicalLogFiles logFiles, FileSystemAbstraction fs, LogVersionRepository logVersionRepository, LatestCheckPointFinder checkPointFinder, TransactionIdStore transactionIdStore, LogicalTransactionStore logicalTransactionStore) {
        this.storageEngine = storageEngine;
        this.logFiles = logFiles;
        this.fs = fs;
        this.logVersionRepository = logVersionRepository;
        this.transactionIdStore = transactionIdStore;
        this.logicalTransactionStore = logicalTransactionStore;
        this.positionToRecoverFrom = new PositionToRecoverFrom(checkPointFinder);
    }

    @Override
    public void forceEverything() {
        IOLimiter unlimited = IOLimiter.unlimited();
        this.storageEngine.flushAndForce(unlimited);
    }

    @Override
    public LogPosition getPositionToRecoverFrom() throws IOException {
        return this.positionToRecoverFrom.apply(this.logVersionRepository.getCurrentLogVersion());
    }

    @Override
    public Visitor<CommittedTransactionRepresentation, Exception> startRecovery() {
        this.storageEngine.prepareForRecoveryRequired();
        this.transactionsToApply = new TransactionQueue(10000, (first, last) -> this.storageEngine.apply(first, TransactionApplicationMode.RECOVERY));
        this.recoveryVisitor = new RecoveryVisitor(this.transactionsToApply);
        return this.recoveryVisitor;
    }

    @Override
    public TransactionCursor getTransactions(LogPosition position) throws IOException {
        return this.logicalTransactionStore.getTransactions(position);
    }

    @Override
    public void allTransactionsRecovered(CommittedTransactionRepresentation lastRecoveredTransaction, LogPosition positionAfterLastRecoveredTransaction) throws Exception {
        this.transactionsToApply.empty();
        this.transactionIdStore.setLastCommittedAndClosedTransactionId(lastRecoveredTransaction.getCommitEntry().getTxId(), LogEntryStart.checksum(lastRecoveredTransaction.getStartEntry()), lastRecoveredTransaction.getCommitEntry().getTimeWritten(), positionAfterLastRecoveredTransaction.getByteOffset(), positionAfterLastRecoveredTransaction.getLogVersion());
        this.fs.truncate(this.logFiles.getLogFileForVersion(positionAfterLastRecoveredTransaction.getLogVersion()), positionAfterLastRecoveredTransaction.getByteOffset());
    }

    static class RecoveryVisitor
    implements Visitor<CommittedTransactionRepresentation, Exception> {
        private final TransactionQueue transactionsToApply;

        public RecoveryVisitor(TransactionQueue transactionsToApply) {
            this.transactionsToApply = transactionsToApply;
        }

        public boolean visit(CommittedTransactionRepresentation transaction) throws Exception {
            TransactionRepresentation txRepresentation = transaction.getTransactionRepresentation();
            long txId = transaction.getCommitEntry().getTxId();
            TransactionToApply tx = new TransactionToApply(txRepresentation, txId);
            tx.commitment(Commitment.NO_COMMITMENT, txId);
            this.transactionsToApply.queue(tx);
            return false;
        }
    }
}

