/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store.io;

import org.neo4j.unsafe.impl.batchimport.IoThroughputStat;
import org.neo4j.unsafe.impl.batchimport.stats.Key;
import org.neo4j.unsafe.impl.batchimport.stats.Keys;
import org.neo4j.unsafe.impl.batchimport.stats.Stat;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;
import org.neo4j.unsafe.impl.batchimport.store.io.IoTracer;

public class IoMonitor
implements StatsProvider {
    private volatile long startTime = System.currentTimeMillis();
    private volatile long endTime;
    private final IoTracer tracer;
    private long resetPoint;

    public IoMonitor(IoTracer tracer) {
        this.tracer = tracer;
    }

    public void reset() {
        this.startTime = System.currentTimeMillis();
        this.endTime = 0L;
        this.resetPoint = this.tracer.countBytesWritten();
    }

    public void stop() {
        this.endTime = System.currentTimeMillis();
    }

    public long startTime() {
        return this.startTime;
    }

    public long totalBytesWritten() {
        return this.tracer.countBytesWritten() - this.resetPoint;
    }

    @Override
    public Stat stat(Key key) {
        if (key == Keys.io_throughput) {
            return new IoThroughputStat(this.startTime, this.endTime, this.totalBytesWritten());
        }
        return null;
    }

    @Override
    public Key[] keys() {
        return new Key[]{Keys.io_throughput};
    }
}

