/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.AvailabilityGuard;

public class CoreAPIAvailabilityGuard {
    private final AvailabilityGuard guard;
    private final long timeout;

    public CoreAPIAvailabilityGuard(AvailabilityGuard guard, long timeout) {
        this.guard = guard;
        this.timeout = timeout;
    }

    public boolean isAvailable(long timeoutMillis) {
        return this.guard.isAvailable(timeoutMillis);
    }

    public void assertDatabaseAvailable() {
        try {
            this.guard.await(this.timeout);
        }
        catch (AvailabilityGuard.UnavailableException e) {
            if (this.guard.isShutdown()) {
                throw new DatabaseShutdownException();
            }
            throw new TransactionFailureException(e.getMessage());
        }
    }
}

