/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.participant;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.store.StorePropertyCursor;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.store.CountsComputer;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RecordCursors;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.format.Capability;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_1;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_2;
import org.neo4j.kernel.impl.store.id.ReadOnlyIdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.storemigration.DirectRecordStoreMigrator;
import org.neo4j.kernel.impl.storemigration.ExistingTargetStrategy;
import org.neo4j.kernel.impl.storemigration.FileOperation;
import org.neo4j.kernel.impl.storemigration.StoreFile;
import org.neo4j.kernel.impl.storemigration.StoreFileType;
import org.neo4j.kernel.impl.storemigration.StoreMigratorCheckPointer;
import org.neo4j.kernel.impl.storemigration.legacylogs.LegacyLogs;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.PropertyDeduplicator;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;
import org.neo4j.kernel.impl.storemigration.monitoring.SilentMigrationProgressMonitor;
import org.neo4j.kernel.impl.storemigration.participant.AbstractStoreMigrationParticipant;
import org.neo4j.kernel.impl.storemigration.participant.StoreScanAsInputIterable;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.ParallelBatchImporter;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdGenerators;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMappers;
import org.neo4j.unsafe.impl.batchimport.input.Collectors;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.input.Inputs;
import org.neo4j.unsafe.impl.batchimport.staging.CoarseBoundedProgressExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionSupervisors;
import org.neo4j.unsafe.impl.batchimport.store.BatchingNeoStores;

public class StoreMigrator
extends AbstractStoreMigrationParticipant {
    private static final char TX_LOG_COUNTERS_SEPARATOR = 'A';
    private final Config config;
    private final LogService logService;
    private final LegacyLogs legacyLogs;
    private final FileSystemAbstraction fileSystem;
    private final PageCache pageCache;
    private final SchemaIndexProvider schemaIndexProvider;

    public StoreMigrator(FileSystemAbstraction fileSystem, PageCache pageCache, Config config, LogService logService, SchemaIndexProvider schemaIndexProvider) {
        this(fileSystem, pageCache, config, logService, schemaIndexProvider, new LegacyLogs(fileSystem));
    }

    public StoreMigrator(FileSystemAbstraction fileSystem, PageCache pageCache, Config config, LogService logService, SchemaIndexProvider schemaIndexProvider, LegacyLogs legacyLogs) {
        super("Store files");
        this.fileSystem = fileSystem;
        this.pageCache = pageCache;
        this.config = config;
        this.logService = logService;
        this.schemaIndexProvider = schemaIndexProvider;
        this.legacyLogs = legacyLogs;
    }

    @Override
    public void migrate(File storeDir, File migrationDir, MigrationProgressMonitor.Section progressMonitor, String versionToMigrateFrom, String versionToMigrateTo) throws IOException {
        RecordFormats newFormat;
        RecordFormats oldFormat;
        File neoStore = new File(storeDir, "neostore");
        long lastTxId = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_TRANSACTION_ID);
        TransactionId lastTxInfo = this.extractTransactionIdInformation(neoStore, storeDir, lastTxId);
        LogPosition lastTxLogPosition = this.extractTransactionLogPosition(neoStore, storeDir, lastTxId);
        this.writeLastTxInformation(migrationDir, lastTxInfo);
        this.writeLastTxLogPosition(migrationDir, lastTxLogPosition);
        if (versionToMigrateFrom.equals("vE.H.0")) {
            versionToMigrateFrom = "vE.H.0b";
        }
        if (!(oldFormat = RecordFormatSelector.selectForVersion(versionToMigrateFrom)).equals(newFormat = RecordFormatSelector.selectForVersion(versionToMigrateTo))) {
            this.migrateWithBatchImporter(storeDir, migrationDir, lastTxId, lastTxInfo.checksum(), lastTxLogPosition.getLogVersion(), lastTxLogPosition.getByteOffset(), progressMonitor, oldFormat, newFormat);
        }
        if (versionToMigrateFrom.equals(StandardV2_1.STORE_VERSION)) {
            this.removeDuplicateEntityProperties(storeDir, migrationDir, this.pageCache, this.schemaIndexProvider, oldFormat);
        }
    }

    void writeLastTxInformation(File migrationDir, TransactionId txInfo) throws IOException {
        StoreMigrator.writeTxLogCounters(this.fileSystem, StoreMigrator.lastTxInformationFile(migrationDir), txInfo.transactionId(), txInfo.checksum(), txInfo.commitTimestamp());
    }

    void writeLastTxLogPosition(File migrationDir, LogPosition lastTxLogPosition) throws IOException {
        StoreMigrator.writeTxLogCounters(this.fileSystem, StoreMigrator.lastTxLogPositionFile(migrationDir), lastTxLogPosition.getLogVersion(), lastTxLogPosition.getByteOffset());
    }

    TransactionId readLastTxInformation(File migrationDir) throws IOException {
        long[] counters = StoreMigrator.readTxLogCounters(this.fileSystem, StoreMigrator.lastTxInformationFile(migrationDir), 3);
        return new TransactionId(counters[0], counters[1], counters[2]);
    }

    LogPosition readLastTxLogPosition(File migrationDir) throws IOException {
        long[] counters = StoreMigrator.readTxLogCounters(this.fileSystem, StoreMigrator.lastTxLogPositionFile(migrationDir), 2);
        return new LogPosition(counters[0], counters[1]);
    }

    private static void writeTxLogCounters(FileSystemAbstraction fs, File file, long ... counters) throws IOException {
        try (Writer writer = fs.openAsWriter(file, StandardCharsets.UTF_8, false);){
            writer.write(StringUtils.join((long[])counters, (char)'A'));
        }
    }

    private static long[] readTxLogCounters(FileSystemAbstraction fs, File file, int numberOfCounters) throws IOException {
        try (BufferedReader reader = new BufferedReader(fs.openAsReader(file, StandardCharsets.UTF_8));){
            String line = reader.readLine();
            String[] split = StringUtils.split((String)line, (char)'A');
            if (split.length != numberOfCounters) {
                throw new IllegalArgumentException("Unexpected number of tx counters '" + numberOfCounters + "', file contains: '" + line + "'");
            }
            long[] counters = new long[numberOfCounters];
            for (int i = 0; i < split.length; ++i) {
                counters[i] = Long.parseLong(split[i]);
            }
            long[] lArray = counters;
            return lArray;
        }
    }

    private static File lastTxInformationFile(File migrationDir) {
        return new File(migrationDir, "lastxinformation");
    }

    private static File lastTxLogPositionFile(File migrationDir) {
        return new File(migrationDir, "lastxlogposition");
    }

    TransactionId extractTransactionIdInformation(File neoStore, File storeDir, long lastTransactionId) throws IOException {
        long checksum = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_TRANSACTION_CHECKSUM);
        long commitTimestamp = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_TRANSACTION_COMMIT_TIMESTAMP);
        if (checksum != -1L && commitTimestamp != -1L) {
            return new TransactionId(lastTransactionId, checksum, commitTimestamp);
        }
        Optional<TransactionId> transactionInformation = this.legacyLogs.getTransactionInformation(storeDir, lastTransactionId);
        return transactionInformation.orElseGet(this.specificTransactionInformationSupplier(lastTransactionId));
    }

    private Supplier<TransactionId> specificTransactionInformationSupplier(long lastTransactionId) {
        return () -> lastTransactionId == 1L ? new TransactionId(lastTransactionId, 0L, 0L) : new TransactionId(lastTransactionId, 1L, 1L);
    }

    private LogPosition extractTransactionLogPosition(File neoStore, File storeDir, long lastTxId) throws IOException {
        long lastClosedTxLogVersion = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_VERSION);
        long lastClosedTxLogByteOffset = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET);
        if (lastClosedTxLogVersion != -1L && lastClosedTxLogByteOffset != -1L) {
            return new LogPosition(lastClosedTxLogVersion, lastClosedTxLogByteOffset);
        }
        if (lastTxId == 1L) {
            return new LogPosition(0L, 16L);
        }
        PhysicalLogFiles logFiles = new PhysicalLogFiles(storeDir, this.fileSystem);
        long logVersion = logFiles.getHighestLogVersion();
        if (logVersion == -1L) {
            return new LogPosition(0L, 16L);
        }
        long offset = this.fileSystem.getFileSize(logFiles.getLogFileForVersion(logVersion));
        return new LogPosition(logVersion, offset);
    }

    private void removeDuplicateEntityProperties(File storeDir, File migrationDir, PageCache pageCache, SchemaIndexProvider schemaIndexProvider, RecordFormats oldFormat) throws IOException {
        StoreFile.fileOperation(FileOperation.COPY, this.fileSystem, storeDir, migrationDir, Iterables.iterable((Object[])new StoreFile[]{StoreFile.PROPERTY_STORE, StoreFile.PROPERTY_KEY_TOKEN_NAMES_STORE, StoreFile.PROPERTY_KEY_TOKEN_STORE, StoreFile.PROPERTY_ARRAY_STORE, StoreFile.PROPERTY_STRING_STORE, StoreFile.NODE_STORE, StoreFile.NODE_LABEL_STORE, StoreFile.SCHEMA_STORE}), false, ExistingTargetStrategy.SKIP, StoreFileType.STORE);
        StoreFile.fileOperation(FileOperation.COPY, this.fileSystem, storeDir, migrationDir, Iterables.iterable((Object[])new StoreFile[]{StoreFile.PROPERTY_STORE, StoreFile.PROPERTY_KEY_TOKEN_NAMES_STORE, StoreFile.PROPERTY_KEY_TOKEN_STORE, StoreFile.NODE_STORE}), true, ExistingTargetStrategy.SKIP, StoreFileType.ID);
        StoreFile.removeTrailers(oldFormat.storeVersion(), this.fileSystem, migrationDir, pageCache.pageSize());
        new PropertyDeduplicator(this.fileSystem, migrationDir, pageCache, schemaIndexProvider).deduplicateProperties();
    }

    private void rebuildCountsFromScratch(File storeDir, long lastTxId, PageCache pageCache) {
        File storeFileBase = new File(storeDir, "neostore.counts.db");
        StoreFactory storeFactory = new StoreFactory(storeDir, pageCache, this.fileSystem, (LogProvider)NullLogProvider.getInstance());
        try (NeoStores neoStores = storeFactory.openAllNeoStores();){
            NodeStore nodeStore = neoStores.getNodeStore();
            RelationshipStore relationshipStore = neoStores.getRelationshipStore();
            try (Lifespan life = new Lifespan(new Lifecycle[0]);){
                int highLabelId = (int)neoStores.getLabelTokenStore().getHighId();
                int highRelationshipTypeId = (int)neoStores.getRelationshipTypeTokenStore().getHighId();
                CountsComputer initializer = new CountsComputer(lastTxId, nodeStore, relationshipStore, highLabelId, highRelationshipTypeId);
                life.add((Lifecycle)new CountsTracker(this.logService.getInternalLogProvider(), this.fileSystem, pageCache, this.config, storeFileBase).setInitializer(initializer));
            }
        }
    }

    private void migrateWithBatchImporter(File storeDir, File migrationDir, long lastTxId, long lastTxChecksum, long lastTxLogVersion, long lastTxLogByteOffset, MigrationProgressMonitor.Section progressMonitor, RecordFormats oldFormat, RecordFormats newFormat) throws IOException {
        this.prepareBatchImportMigration(storeDir, migrationDir, oldFormat, newFormat);
        boolean requiresDynamicStoreMigration = !newFormat.dynamic().equals(oldFormat.dynamic());
        boolean requiresPropertyMigration = !newFormat.property().equals(oldFormat.property()) || requiresDynamicStoreMigration;
        File badFile = new File(storeDir, "bad.log");
        try (NeoStores legacyStore = this.instantiateLegacyStore(oldFormat, storeDir);
             RecordCursors nodeInputCursors = new RecordCursors(legacyStore);
             RecordCursors relationshipInputCursors = new RecordCursors(legacyStore);
             BufferedOutputStream badOutput = new BufferedOutputStream(new FileOutputStream(badFile, false));){
            Configuration.Overridden importConfig = new Configuration.Overridden(this.config);
            AdditionalInitialIds additionalInitialIds = this.readAdditionalIds(lastTxId, lastTxChecksum, lastTxLogVersion, lastTxLogByteOffset);
            ParallelBatchImporter importer = new ParallelBatchImporter(migrationDir.getAbsoluteFile(), this.fileSystem, importConfig, this.logService, ExecutionSupervisors.withDynamicProcessorAssignment(this.migrationBatchImporterMonitor(legacyStore, progressMonitor, importConfig), importConfig), additionalInitialIds, this.config);
            InputIterable<InputNode> nodes = this.legacyNodesAsInput(legacyStore, requiresPropertyMigration, nodeInputCursors);
            InputIterable<InputRelationship> relationships = this.legacyRelationshipsAsInput(legacyStore, requiresPropertyMigration, relationshipInputCursors);
            importer.doImport(Inputs.input(nodes, relationships, IdMappers.actual(), IdGenerators.fromInput(), Collectors.badCollector(badOutput, 0)));
            ArrayList<StoreFile> storesToDeleteFromMigratedDirectory = new ArrayList<StoreFile>();
            storesToDeleteFromMigratedDirectory.add(StoreFile.NEO_STORE);
            if (!requiresPropertyMigration) {
                storesToDeleteFromMigratedDirectory.addAll(Arrays.asList(StoreFile.PROPERTY_STORE, StoreFile.PROPERTY_STRING_STORE, StoreFile.PROPERTY_ARRAY_STORE));
            }
            if (!requiresDynamicStoreMigration) {
                storesToDeleteFromMigratedDirectory.addAll(Arrays.asList(StoreFile.NODE_LABEL_STORE, StoreFile.LABEL_TOKEN_STORE, StoreFile.LABEL_TOKEN_NAMES_STORE, StoreFile.RELATIONSHIP_TYPE_TOKEN_STORE, StoreFile.RELATIONSHIP_TYPE_TOKEN_NAMES_STORE, StoreFile.PROPERTY_KEY_TOKEN_STORE, StoreFile.PROPERTY_KEY_TOKEN_NAMES_STORE, StoreFile.SCHEMA_STORE));
            }
            StoreFile.fileOperation(FileOperation.DELETE, this.fileSystem, migrationDir, null, storesToDeleteFromMigratedDirectory, true, null, StoreFileType.values());
        }
    }

    private NeoStores instantiateLegacyStore(RecordFormats format, File storeDir) {
        return new StoreFactory(storeDir, this.config, new ReadOnlyIdGeneratorFactory(), this.pageCache, this.fileSystem, format, (LogProvider)NullLogProvider.getInstance()).openAllNeoStores(true);
    }

    private void prepareBatchImportMigration(File storeDir, File migrationDir, RecordFormats oldFormat, RecordFormats newFormat) throws IOException {
        BatchingNeoStores.createStore(this.fileSystem, migrationDir.getPath(), this.config, newFormat);
        StoreFile[] storesFilesToMigrate = new StoreFile[]{StoreFile.LABEL_TOKEN_STORE, StoreFile.LABEL_TOKEN_NAMES_STORE, StoreFile.PROPERTY_KEY_TOKEN_STORE, StoreFile.PROPERTY_KEY_TOKEN_NAMES_STORE, StoreFile.RELATIONSHIP_TYPE_TOKEN_STORE, StoreFile.RELATIONSHIP_TYPE_TOKEN_NAMES_STORE, StoreFile.NODE_LABEL_STORE};
        if (newFormat.dynamic().equals(oldFormat.dynamic())) {
            StoreFile.fileOperation(FileOperation.COPY, this.fileSystem, storeDir, migrationDir, Arrays.asList(storesFilesToMigrate), true, ExistingTargetStrategy.FAIL, StoreFileType.values());
        } else {
            DirectRecordStoreMigrator migrator = new DirectRecordStoreMigrator(this.pageCache, this.fileSystem, this.config);
            StoreType[] storesToMigrate = new StoreType[]{StoreType.LABEL_TOKEN, StoreType.LABEL_TOKEN_NAME, StoreType.PROPERTY_KEY_TOKEN, StoreType.PROPERTY_KEY_TOKEN_NAME, StoreType.RELATIONSHIP_TYPE_TOKEN, StoreType.RELATIONSHIP_TYPE_TOKEN_NAME, StoreType.NODE_LABEL, StoreType.SCHEMA};
            MigrationProgressMonitor.Section section = SilentMigrationProgressMonitor.NO_OP_SECTION;
            migrator.migrate(storeDir, oldFormat, migrationDir, newFormat, section, storesToMigrate, StoreType.NODE);
        }
    }

    private AdditionalInitialIds readAdditionalIds(final long lastTxId, final long lastTxChecksum, final long lastTxLogVersion, final long lastTxLogByteOffset) throws IOException {
        return new AdditionalInitialIds(){

            @Override
            public long lastCommittedTransactionId() {
                return lastTxId;
            }

            @Override
            public long lastCommittedTransactionChecksum() {
                return lastTxChecksum;
            }

            @Override
            public long lastCommittedTransactionLogVersion() {
                return lastTxLogVersion;
            }

            @Override
            public long lastCommittedTransactionLogByteOffset() {
                return lastTxLogByteOffset;
            }
        };
    }

    private ExecutionMonitor migrationBatchImporterMonitor(NeoStores legacyStore, MigrationProgressMonitor.Section progressMonitor, org.neo4j.unsafe.impl.batchimport.Configuration config) {
        return new BatchImporterProgressMonitor(legacyStore.getNodeStore().getHighId(), legacyStore.getRelationshipStore().getHighId(), config, progressMonitor);
    }

    private InputIterable<InputRelationship> legacyRelationshipsAsInput(NeoStores legacyStore, boolean requiresPropertyMigration, RecordCursors cursors) {
        RelationshipStore store = legacyStore.getRelationshipStore();
        final BiConsumer propertyDecorator = this.propertyDecorator(requiresPropertyMigration, cursors);
        return new StoreScanAsInputIterable<InputRelationship, RelationshipRecord>((RecordStore)store){

            @Override
            protected InputRelationship inputEntityOf(RelationshipRecord record) {
                InputRelationship result = new InputRelationship("legacy store", record.getId(), record.getId() * 34L, InputEntity.NO_PROPERTIES, record.getNextProp(), record.getFirstNode(), record.getSecondNode(), null, record.getType());
                propertyDecorator.accept(result, record);
                return result;
            }
        };
    }

    private InputIterable<InputNode> legacyNodesAsInput(NeoStores legacyStore, boolean requiresPropertyMigration, RecordCursors cursors) {
        NodeStore store = legacyStore.getNodeStore();
        final BiConsumer propertyDecorator = this.propertyDecorator(requiresPropertyMigration, cursors);
        return new StoreScanAsInputIterable<InputNode, NodeRecord>((RecordStore)store){

            @Override
            protected InputNode inputEntityOf(NodeRecord record) {
                InputNode node = new InputNode("legacy store", record.getId(), record.getId() * 15L, record.getId(), InputEntity.NO_PROPERTIES, record.getNextProp(), InputNode.NO_LABELS, record.getLabelField());
                propertyDecorator.accept(node, record);
                return node;
            }
        };
    }

    private <ENTITY extends InputEntity, RECORD extends PrimitiveRecord> BiConsumer<ENTITY, RECORD> propertyDecorator(boolean requiresPropertyMigration, RecordCursors cursors) {
        if (!requiresPropertyMigration) {
            return (a, b) -> {};
        }
        StorePropertyCursor cursor = new StorePropertyCursor(cursors, ignored -> {});
        ArrayList scratch = new ArrayList();
        return (entity, record) -> {
            cursor.init(record.getNextProp(), LockService.NO_LOCK);
            scratch.clear();
            while (cursor.next()) {
                scratch.add(cursor.propertyKeyId());
                scratch.add(cursor.value());
            }
            entity.setProperties(scratch.isEmpty() ? InputEntity.NO_PROPERTIES : scratch.toArray());
            cursor.close();
        };
    }

    @Override
    public void moveMigratedFiles(File migrationDir, File storeDir, String versionToUpgradeFrom, String versionToUpgradeTo) throws IOException {
        boolean movingAwayFromVersionTrailers;
        StoreFile.fileOperation(FileOperation.MOVE, this.fileSystem, migrationDir, storeDir, StoreFile.currentStoreFiles(), true, ExistingTargetStrategy.OVERWRITE, StoreFileType.values());
        RecordFormats oldFormat = RecordFormatSelector.selectForVersion(versionToUpgradeFrom);
        RecordFormats newFormat = RecordFormatSelector.selectForVersion(versionToUpgradeTo);
        boolean bl = movingAwayFromVersionTrailers = oldFormat.hasCapability(Capability.VERSION_TRAILERS) && !newFormat.hasCapability(Capability.VERSION_TRAILERS);
        if (movingAwayFromVersionTrailers) {
            StoreFile.removeTrailers(versionToUpgradeFrom, this.fileSystem, storeDir, this.pageCache.pageSize());
        }
        File neoStore = new File(storeDir, "neostore");
        long logVersion = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LOG_VERSION);
        long lastCommittedTx = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_TRANSACTION_ID);
        this.updateOrAddNeoStoreFieldsAsPartOfMigration(migrationDir, storeDir, versionToUpgradeTo);
        this.legacyLogs.deleteUnusedLogFiles(storeDir);
        if (movingAwayFromVersionTrailers) {
            new StoreMigratorCheckPointer(storeDir, this.fileSystem).checkPoint(logVersion, lastCommittedTx);
        }
    }

    @Override
    public void rebuildCounts(File storeDir, String versionToMigrateFrom, String versionToMigrateTo) throws IOException {
        if (StandardV2_1.STORE_VERSION.equals(versionToMigrateFrom) || StandardV2_2.STORE_VERSION.equals(versionToMigrateFrom)) {
            Iterable countsStoreFiles = Iterables.iterable((Object[])new StoreFile[]{StoreFile.COUNTS_STORE_LEFT, StoreFile.COUNTS_STORE_RIGHT});
            StoreFile.fileOperation(FileOperation.DELETE, this.fileSystem, storeDir, storeDir, countsStoreFiles, true, null, StoreFileType.STORE);
            File neoStore = new File(storeDir, "neostore");
            long lastTxId = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_TRANSACTION_ID);
            this.rebuildCountsFromScratch(storeDir, lastTxId, this.pageCache);
        }
    }

    private void updateOrAddNeoStoreFieldsAsPartOfMigration(File migrationDir, File storeDir, String versionToMigrateTo) throws IOException {
        File storeDirNeoStore = new File(storeDir, "neostore");
        MetaDataStore.setRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.UPGRADE_TRANSACTION_ID, MetaDataStore.getRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.LAST_TRANSACTION_ID));
        MetaDataStore.setRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.UPGRADE_TIME, System.currentTimeMillis());
        TransactionId lastTxInfo = this.readLastTxInformation(migrationDir);
        MetaDataStore.setRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.LAST_TRANSACTION_CHECKSUM, lastTxInfo.checksum());
        MetaDataStore.setRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.UPGRADE_TRANSACTION_CHECKSUM, lastTxInfo.checksum());
        MetaDataStore.setRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.LAST_TRANSACTION_COMMIT_TIMESTAMP, lastTxInfo.commitTimestamp());
        MetaDataStore.setRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.UPGRADE_TRANSACTION_COMMIT_TIMESTAMP, lastTxInfo.commitTimestamp());
        LogPosition logPosition = this.readLastTxLogPosition(migrationDir);
        MetaDataStore.setRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_VERSION, logPosition.getLogVersion());
        MetaDataStore.setRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET, logPosition.getByteOffset());
        MetaDataStore.setRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.STORE_VERSION, MetaDataStore.versionStringToLong(versionToMigrateTo));
    }

    @Override
    public void cleanup(File migrationDir) throws IOException {
        this.fileSystem.deleteRecursively(migrationDir);
    }

    public String toString() {
        return "Kernel StoreMigrator";
    }

    private class BatchImporterProgressMonitor
    extends CoarseBoundedProgressExecutionMonitor {
        private final MigrationProgressMonitor.Section progressMonitor;

        BatchImporterProgressMonitor(long highNodeId, long highRelationshipId, Configuration configuration, MigrationProgressMonitor.Section progressMonitor) {
            super(highNodeId, highRelationshipId, configuration);
            this.progressMonitor = progressMonitor;
            this.progressMonitor.start(this.total());
        }

        @Override
        protected void progress(long progress) {
            this.progressMonitor.progress(progress);
        }
    }
}

