/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.TransactionHook;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.api.proc.CallableUserFunction;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.api.TransactionHooks;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class Kernel
extends LifecycleAdapter
implements KernelAPI {
    private final KernelTransactions transactions;
    private final TransactionHooks hooks;
    private final DatabaseHealth health;
    private final TransactionMonitor transactionMonitor;
    private final Procedures procedures;
    private final long defaultTransactionTimeout;

    public Kernel(KernelTransactions transactionFactory, TransactionHooks hooks, DatabaseHealth health, TransactionMonitor transactionMonitor, Procedures procedures, Config config) {
        this.transactions = transactionFactory;
        this.hooks = hooks;
        this.health = health;
        this.transactionMonitor = transactionMonitor;
        this.procedures = procedures;
        this.defaultTransactionTimeout = config.get(GraphDatabaseSettings.transaction_timeout);
    }

    @Override
    public KernelTransaction newTransaction(KernelTransaction.Type type, SecurityContext securityContext) throws TransactionFailureException {
        return this.newTransaction(type, securityContext, this.defaultTransactionTimeout);
    }

    @Override
    public KernelTransaction newTransaction(KernelTransaction.Type type, SecurityContext securityContext, long timeout) throws TransactionFailureException {
        this.health.assertHealthy(TransactionFailureException.class);
        this.transactionMonitor.transactionStarted();
        try {
            return this.transactions.newInstance(type, securityContext, timeout);
        }
        catch (Throwable t) {
            this.transactionMonitor.transactionFinished(false, false);
            throw t;
        }
    }

    @Override
    public void registerTransactionHook(TransactionHook hook) {
        this.hooks.register(hook);
    }

    @Override
    public void unregisterTransactionHook(TransactionHook hook) {
        this.hooks.unregister(hook);
    }

    @Override
    public void registerProcedure(CallableProcedure procedure) throws ProcedureException {
        this.procedures.register(procedure);
    }

    @Override
    public void registerUserFunction(CallableUserFunction function) throws ProcedureException {
        this.procedures.register(function);
    }

    public void stop() throws Throwable {
        this.transactions.disposeAll();
    }
}

