/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.function.Consumer;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.impl.api.store.StoreAbstractRelationshipCursor;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.RecordCursors;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.storageengine.api.Direction;

public class StoreNodeRelationshipCursor
extends StoreAbstractRelationshipCursor {
    private final RelationshipGroupRecord groupRecord;
    private final Consumer<StoreNodeRelationshipCursor> instanceCache;
    private boolean isDense;
    private long relationshipId;
    private long fromNodeId;
    private Direction direction;
    private int[] relTypes;
    private int groupChainIndex;
    private boolean end;
    private final RecordCursors cursors;
    private static final GroupChain[] GROUP_CHAINS = GroupChain.values();

    public StoreNodeRelationshipCursor(RelationshipRecord relationshipRecord, RelationshipGroupRecord groupRecord, Consumer<StoreNodeRelationshipCursor> instanceCache, RecordCursors cursors, LockService lockService) {
        super(relationshipRecord, cursors, lockService);
        this.groupRecord = groupRecord;
        this.instanceCache = instanceCache;
        this.cursors = cursors;
    }

    public StoreNodeRelationshipCursor init(boolean isDense, long firstRelId, long fromNodeId, Direction direction, AssertOpen assertOpen) {
        return this.init(isDense, firstRelId, fromNodeId, direction, assertOpen, null);
    }

    public final StoreNodeRelationshipCursor init(boolean isDense, long firstRelId, long fromNodeId, Direction direction, AssertOpen assertOpen, int ... relTypes) {
        this.isDense = isDense;
        this.relationshipId = firstRelId;
        this.fromNodeId = fromNodeId;
        this.direction = direction;
        this.relTypes = relTypes;
        this.end = false;
        this.initialize(assertOpen);
        if (isDense && this.relationshipId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            this.cursors.relationshipGroup().next(firstRelId, this.groupRecord, RecordLoad.FORCE);
            this.relationshipId = this.nextChainStart();
        } else {
            this.relationshipId = firstRelId;
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean next() {
        block10: while (this.relationshipId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            this.relationshipRecordCursor.next(this.relationshipId, this.relationshipRecord, RecordLoad.FORCE);
            try {
                if (!this.relationshipRecord.inUse()) continue;
                if (this.direction == Direction.BOTH) {
                }
                switch (this.direction) {
                    case INCOMING: {
                        if (this.relationshipRecord.getSecondNode() != this.fromNodeId) continue block10;
                    }
                    case OUTGOING: {
                        if (this.relationshipRecord.getFirstNode() == this.fromNodeId) break;
                        continue block10;
                    }
                    default: {
                        throw new IllegalStateException("Unknown direction: " + (Object)((Object)this.direction));
                    }
                }
            }
            finally {
                if (this.relationshipRecord.getFirstNode() == this.fromNodeId) {
                    this.relationshipId = this.relationshipRecord.getFirstNextRel();
                } else {
                    if (this.relationshipRecord.getSecondNode() != this.fromNodeId) {
                        throw new InvalidRecordException("While loading relationships for Node[" + this.fromNodeId + "] a Relationship[" + this.relationshipRecord.getId() + "] was encountered that had startNode: " + this.relationshipRecord.getFirstNode() + " and endNode: " + this.relationshipRecord.getSecondNode() + ", i.e. which had neither start nor end node as the node we're loading relationships for");
                    }
                    this.relationshipId = this.relationshipRecord.getSecondNextRel();
                }
                if (this.relationshipId != (long)Record.NO_NEXT_RELATIONSHIP.intValue() || !this.isDense) continue;
                this.relationshipId = this.nextChainStart();
                continue;
            }
            break;
        }
        return false;
    }

    public void close() {
        this.instanceCache.accept(this);
    }

    private long nextChainStart() {
        try {
            while (!this.end) {
                if (this.groupRecord.inUse() && this.checkType(this.groupRecord.getType())) {
                    while (this.groupChainIndex < GROUP_CHAINS.length) {
                        GroupChain groupChain;
                        long chainStart;
                        if (Record.NULL_REFERENCE.is(chainStart = (groupChain = GROUP_CHAINS[this.groupChainIndex++]).chainStart(this.groupRecord)) || this.direction != Direction.BOTH && !groupChain.matchesDirection(this.direction)) continue;
                        return chainStart;
                    }
                }
                if (!Record.NULL_REFERENCE.is(this.groupRecord.getNext())) {
                    this.cursors.relationshipGroup().next(this.groupRecord.getNext(), this.groupRecord, RecordLoad.FORCE);
                } else {
                    this.end = true;
                }
                this.groupChainIndex = 0;
            }
        }
        catch (InvalidRecordException invalidRecordException) {
            // empty catch block
        }
        return Record.NULL_REFERENCE.intValue();
    }

    private boolean checkType(int type) {
        if (this.relTypes != null) {
            for (int relType : this.relTypes) {
                if (type != relType) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static enum GroupChain {
        OUT{

            @Override
            long chainStart(RelationshipGroupRecord groupRecord) {
                return groupRecord.getFirstOut();
            }

            @Override
            boolean matchesDirection(Direction direction) {
                return direction == Direction.OUTGOING;
            }
        }
        ,
        IN{

            @Override
            long chainStart(RelationshipGroupRecord groupRecord) {
                return groupRecord.getFirstIn();
            }

            @Override
            boolean matchesDirection(Direction direction) {
                return direction == Direction.INCOMING;
            }
        }
        ,
        LOOP{

            @Override
            long chainStart(RelationshipGroupRecord groupRecord) {
                return groupRecord.getFirstLoop();
            }

            @Override
            boolean matchesDirection(Direction direction) {
                return true;
            }
        };


        abstract long chainStart(RelationshipGroupRecord var1);

        abstract boolean matchesDirection(Direction var1);
    }
}

