/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;

public final class SilentTokenNameLookup
implements TokenNameLookup {
    private final TokenRead tokenRead;

    public SilentTokenNameLookup(TokenRead tokenRead) {
        this.tokenRead = tokenRead;
    }

    public String labelGetName(int labelId) {
        try {
            return this.tokenRead.nodeLabelName(labelId);
        }
        catch (LabelNotFoundKernelException e) {
            return "[" + labelId + "]";
        }
    }

    public String relationshipTypeGetName(int relTypeId) {
        try {
            return this.tokenRead.relationshipTypeName(relTypeId);
        }
        catch (KernelException e) {
            return "[" + relTypeId + "]";
        }
    }

    public String propertyKeyGetName(int propertyKeyId) {
        try {
            return this.tokenRead.propertyKeyName(propertyKeyId);
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            return "[" + propertyKeyId + "]";
        }
    }
}

