/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.ReadAheadChannel;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.io.pagecache.ByteArrayPageCursor;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.ReadableChannelPageCursor;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.concurrent.Runnables;

public abstract class SimpleEntryStorage<ENTRY, CURSOR>
implements Closeable {
    static final int TYPE_SIZE = 1;
    static final byte STOP_TYPE = -1;
    private static final byte[] NO_ENTRIES = new byte[]{-1};
    private final Path file;
    private final FileSystemAbstraction fs;
    private final int blockSize;
    private final MemoryTracker memoryTracker;
    private final ByteBufferFactory.Allocator byteBufferFactory;
    private boolean allocated;
    private ScopedBuffer scopedBuffer;
    private ByteBuffer buffer;
    private ByteArrayPageCursor pageCursor;
    private StoreChannel storeChannel;
    private final AtomicLong count = new AtomicLong();

    SimpleEntryStorage(FileSystemAbstraction fs, Path file, ByteBufferFactory.Allocator byteBufferFactory, int blockSize, MemoryTracker memoryTracker) {
        this.fs = fs;
        this.file = file;
        this.byteBufferFactory = byteBufferFactory;
        this.blockSize = blockSize;
        this.memoryTracker = memoryTracker;
    }

    void add(ENTRY entry) throws IOException {
        this.allocateResources();
        this.add(entry, (PageCursor)this.pageCursor);
        this.count.incrementAndGet();
    }

    CURSOR reader() throws IOException {
        if (!this.allocated) {
            return this.reader(ByteArrayPageCursor.wrap((byte[])NO_ENTRIES));
        }
        ReadAheadChannel channel = new ReadAheadChannel(this.fs.read(this.file), this.byteBufferFactory.allocate(this.blockSize, this.memoryTracker));
        ReadableChannelPageCursor pageCursor = new ReadableChannelPageCursor((ReadableChannel)channel);
        return this.reader(pageCursor);
    }

    long count() {
        return this.count.get();
    }

    void doneAdding() throws IOException {
        if (!this.allocated) {
            return;
        }
        if (this.buffer.remaining() < 1) {
            this.flush();
        }
        this.pageCursor.putByte((byte)-1);
        this.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.allocated) {
            Runnables.runAll((String)("Failed while trying to close " + this.getClass().getSimpleName()), (Runnable[])new Runnable[]{() -> IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{this.pageCursor, this.storeChannel, this.scopedBuffer}), () -> {
                try {
                    this.fs.deleteFile(this.file);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }});
        } else if (this.fs.fileExists(this.file)) {
            this.fs.deleteFile(this.file);
        }
    }

    abstract void add(ENTRY var1, PageCursor var2) throws IOException;

    abstract CURSOR reader(PageCursor var1) throws IOException;

    void prepareWrite(int entrySize) throws IOException {
        if (entrySize > this.buffer.remaining()) {
            this.flush();
        }
    }

    private void flush() throws IOException {
        this.buffer.flip();
        this.storeChannel.writeAll(this.buffer);
        this.buffer.clear();
    }

    private void allocateResources() throws IOException {
        if (!this.allocated) {
            this.scopedBuffer = this.byteBufferFactory.allocate(this.blockSize, this.memoryTracker);
            this.buffer = this.scopedBuffer.getBuffer();
            this.pageCursor = new ByteArrayPageCursor(this.buffer);
            this.storeChannel = this.fs.write(this.file);
            this.allocated = true;
        }
    }
}

