/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.function.Function;
import java.util.function.IntPredicate;
import org.neo4j.configuration.Config;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.api.index.PropertyScanConsumer;
import org.neo4j.kernel.impl.api.index.TokenScanConsumer;
import org.neo4j.kernel.impl.transaction.state.storeview.PropertyAwareEntityStoreScan;
import org.neo4j.kernel.impl.transaction.state.storeview.RelationshipCursorBehaviour;
import org.neo4j.lock.LockService;
import org.neo4j.lock.LockType;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageRelationshipScanCursor;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class RelationshipStoreScan
extends PropertyAwareEntityStoreScan<StorageRelationshipScanCursor> {
    private static final String TRACER_TAG = "RelationshipStoreScan_getRelationshipCount";

    public RelationshipStoreScan(Config config, StorageReader storageReader, Function<CursorContext, StoreCursors> storeCursorsFactory, LockService locks, TokenScanConsumer relationshipTypeScanConsumer, PropertyScanConsumer propertyScanConsumer, int[] relationshipTypeIds, IntPredicate propertyKeyIdFilter, boolean parallelWrite, JobScheduler scheduler, CursorContextFactory contextFactory, MemoryTracker memoryTracker) {
        super(config, storageReader, storeCursorsFactory, RelationshipStoreScan.getRelationshipCount(storageReader, contextFactory), relationshipTypeIds, propertyKeyIdFilter, propertyScanConsumer, relationshipTypeScanConsumer, id -> locks.acquireRelationshipLock(id, LockType.SHARED), new RelationshipCursorBehaviour(storageReader), parallelWrite, scheduler, contextFactory, memoryTracker, true);
    }

    private static long getRelationshipCount(StorageReader storageReader, CursorContextFactory contextFactory) {
        try (CursorContext cursorContext = contextFactory.create(TRACER_TAG);){
            long l = storageReader.relationshipsGetCount(cursorContext);
            return l;
        }
    }
}

