/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TopDocs;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.direct.AllEntriesLabelScanReader;
import org.neo4j.kernel.api.impl.index.BitmapDocumentFormat;
import org.neo4j.kernel.api.impl.index.LabelScanStorageStrategy;
import org.neo4j.kernel.api.impl.index.LuceneAllDocumentsReader;
import org.neo4j.kernel.api.impl.index.LuceneAllEntriesLabelScanReader;
import org.neo4j.kernel.api.impl.index.LuceneLabelScanWriter;
import org.neo4j.kernel.api.impl.index.PageOfRangesIterator;
import org.neo4j.kernel.impl.util.PrimitiveLongIterator;
import org.neo4j.unsafe.batchinsert.LabelScanWriter;

public class NodeRangeDocumentLabelScanStorageStrategy
implements LabelScanStorageStrategy {
    private static final int RANGES_PER_PAGE = 4096;
    private final BitmapDocumentFormat format;

    public NodeRangeDocumentLabelScanStorageStrategy() {
        this(BitmapDocumentFormat._32);
    }

    NodeRangeDocumentLabelScanStorageStrategy(BitmapDocumentFormat format) {
        this.format = format;
    }

    public String toString() {
        return String.format("%s{%s}", new Object[]{this.getClass().getSimpleName(), this.format});
    }

    @Override
    public PrimitiveLongIterator nodesWithLabel(IndexSearcher searcher, int labelId) {
        return IteratorUtil.flatten((Iterator)((Object)new PageOfRangesIterator(this.format, searcher, 4096, this.format.labelQuery(labelId), labelId)));
    }

    @Override
    public AllEntriesLabelScanReader newNodeLabelReader(SearcherManager searcherManager) {
        return new LuceneAllEntriesLabelScanReader(new LuceneAllDocumentsReader((ReferenceManager<IndexSearcher>)searcherManager), this.format);
    }

    @Override
    public Iterator<Long> labelsForNode(IndexSearcher searcher, long nodeId) {
        try {
            TopDocs topDocs = searcher.search(this.format.rangeQuery(this.format.bitmapFormat().rangeOf(nodeId)), 1);
            if (topDocs.scoreDocs.length < 1) {
                return IteratorUtil.emptyIterator();
            }
            if (topDocs.scoreDocs.length > 1) {
                throw new RuntimeException("This label scan store is corrupted");
            }
            int doc = topDocs.scoreDocs[0].doc;
            ArrayList<Long> labels = new ArrayList<Long>();
            for (Fieldable fields : searcher.doc(doc).getFields()) {
                if ("range".equals(fields.name()) || !(fields instanceof NumericField)) continue;
                NumericField labelField = (NumericField)fields;
                Long bitmap = Long.decode(labelField.stringValue());
                if (!this.format.bitmapFormat().hasLabel(bitmap, nodeId)) continue;
                labels.add(Long.decode(labelField.name()));
            }
            return labels.iterator();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public LabelScanWriter acquireWriter(LabelScanStorageStrategy.StorageService storage) {
        return new LuceneLabelScanWriter(storage, this.format);
    }
}

