/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.transaction.TransactionManager;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WhitespaceTokenizer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.SnapshotDeletionPolicy;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.PrefetchingResourceIterator;
import org.neo4j.index.impl.lucene.Cache;
import org.neo4j.index.impl.lucene.EntityType;
import org.neo4j.index.impl.lucene.IndexClockCache;
import org.neo4j.index.impl.lucene.IndexIdentifier;
import org.neo4j.index.impl.lucene.IndexReference;
import org.neo4j.index.impl.lucene.IndexType;
import org.neo4j.index.impl.lucene.IndexTypeCache;
import org.neo4j.index.impl.lucene.LuceneCommand;
import org.neo4j.index.impl.lucene.LuceneIndex;
import org.neo4j.index.impl.lucene.LuceneIndexImplementation;
import org.neo4j.index.impl.lucene.LuceneLogTranslator;
import org.neo4j.index.impl.lucene.LuceneTransaction;
import org.neo4j.index.impl.lucene.LuceneXaConnection;
import org.neo4j.index.impl.lucene.MultipleBackupDeletionPolicy;
import org.neo4j.index.impl.lucene.RelationshipId;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.TransactionInterceptorProviders;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.cache.LruCache;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.index.IndexProviderStore;
import org.neo4j.kernel.impl.index.IndexStore;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandReader;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandReaderFactory;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandWriter;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandWriterFactory;
import org.neo4j.kernel.impl.transaction.TransactionStateFactory;
import org.neo4j.kernel.impl.transaction.xaframework.InjectedTransactionValidator;
import org.neo4j.kernel.impl.transaction.xaframework.LogBackedXaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogBufferFactory;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.transaction.xaframework.XaConnection;
import org.neo4j.kernel.impl.transaction.xaframework.XaContainer;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.XaFactory;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransaction;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransactionFactory;

public class LuceneDataSource
extends LogBackedXaDataSource {
    private final Config config;
    private final FileSystemAbstraction fileSystemAbstraction;
    public static final Version LUCENE_VERSION = Version.LUCENE_36;
    public static final String DEFAULT_NAME = "lucene-index";
    public static final byte[] DEFAULT_BRANCH_ID = UTF8.encode((String)"162374");
    public static final long INDEX_VERSION = NeoStore.versionStringToLong((String)"3.5");
    public static final Analyzer LOWER_CASE_WHITESPACE_ANALYZER = new Analyzer(){

        public TokenStream tokenStream(String fieldName, Reader reader) {
            return new LowerCaseFilter(LUCENE_VERSION, (TokenStream)new WhitespaceTokenizer(LUCENE_VERSION, reader));
        }

        public String toString() {
            return "LOWER_CASE_WHITESPACE_ANALYZER";
        }
    };
    public static final Analyzer WHITESPACE_ANALYZER = new Analyzer(){

        public TokenStream tokenStream(String fieldName, Reader reader) {
            return new WhitespaceTokenizer(LUCENE_VERSION, reader);
        }

        public String toString() {
            return "WHITESPACE_ANALYZER";
        }
    };
    public static final Analyzer KEYWORD_ANALYZER = new KeywordAnalyzer();
    private IndexClockCache indexSearchers;
    private XaContainer xaContainer;
    private File baseStorePath;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    final IndexStore indexStore;
    private final XaFactory xaFactory;
    private final TransactionManager txManager;
    IndexProviderStore providerStore;
    private IndexTypeCache typeCache;
    private boolean closed;
    private Cache caching;
    EntityType nodeEntityType;
    EntityType relationshipEntityType;
    final Map<IndexIdentifier, LuceneIndex<? extends PropertyContainer>> indexes = new HashMap<IndexIdentifier, LuceneIndex<? extends PropertyContainer>>();
    private LuceneFilesystemFacade filesystemFacade;
    private final Set<IndexIdentifier> expectedFutureRecoveryDeletions = new HashSet<IndexIdentifier>();

    public LuceneDataSource(Config config, IndexStore indexStore, FileSystemAbstraction fileSystemAbstraction, XaFactory xaFactory, TransactionManager txManager) {
        super(DEFAULT_BRANCH_ID, DEFAULT_NAME);
        this.config = config;
        this.indexStore = indexStore;
        this.xaFactory = xaFactory;
        this.txManager = txManager;
        this.typeCache = new IndexTypeCache(indexStore);
        this.fileSystemAbstraction = fileSystemAbstraction;
    }

    public void init() {
    }

    public void start() {
        this.filesystemFacade = (Boolean)this.config.get(Configuration.ephemeral) != false ? LuceneFilesystemFacade.MEMORY : LuceneFilesystemFacade.FS;
        this.indexSearchers = new IndexClockCache((Integer)this.config.get(Configuration.lucene_searcher_cache_size));
        this.caching = new Cache();
        File storeDir = (File)this.config.get(Configuration.store_dir);
        this.baseStorePath = this.filesystemFacade.ensureDirectoryExists(this.fileSystemAbstraction, this.baseDirectory(storeDir));
        this.filesystemFacade.cleanWriteLocks(this.baseStorePath);
        boolean allowUpgrade = (Boolean)this.config.get(Configuration.allow_store_upgrade);
        this.providerStore = this.newIndexStore(this.baseStorePath, this.fileSystemAbstraction, allowUpgrade);
        this.typeCache = new IndexTypeCache(this.indexStore);
        boolean isReadOnly = (Boolean)this.config.get(Configuration.read_only);
        this.nodeEntityType = new EntityType(){

            @Override
            public Document newDocument(Object entityId) {
                return IndexType.newBaseDocument((Long)entityId);
            }

            @Override
            public Class<? extends PropertyContainer> getType() {
                return Node.class;
            }
        };
        this.relationshipEntityType = new EntityType(){

            @Override
            public Document newDocument(Object entityId) {
                RelationshipId relId = (RelationshipId)entityId;
                Document doc = IndexType.newBaseDocument(relId.id);
                doc.add((Fieldable)new Field("_start_node_id_", "" + relId.startNode, Field.Store.YES, Field.Index.NOT_ANALYZED));
                doc.add((Fieldable)new Field("_end_node_id_", "" + relId.endNode, Field.Store.YES, Field.Index.NOT_ANALYZED));
                return doc;
            }

            @Override
            public Class<? extends PropertyContainer> getType() {
                return Relationship.class;
            }
        };
        LuceneCommandReaderFactory commandReaderFactory = new LuceneCommandReaderFactory(this.nodeEntityType, this.relationshipEntityType);
        LuceneCommandWriterFactory commandWriterFactory = new LuceneCommandWriterFactory();
        LuceneTransactionFactory tf = new LuceneTransactionFactory();
        DependencyResolver.Adapter dummy = new DependencyResolver.Adapter(){

            public <T> T resolveDependency(Class<T> type, DependencyResolver.SelectionStrategy selector) {
                return (T)LuceneDataSource.this.config;
            }
        };
        this.xaContainer = this.xaFactory.newXaContainer((XaDataSource)this, this.logBaseName(this.baseStorePath), (XaCommandReaderFactory)commandReaderFactory, (XaCommandWriterFactory)commandWriterFactory, InjectedTransactionValidator.ALLOW_ALL, (XaTransactionFactory)tf, TransactionStateFactory.noStateFactory(null), new TransactionInterceptorProviders(new HashSet(), (DependencyResolver)dummy), false, (Function)new LuceneLogTranslator());
        this.closed = false;
        if (!isReadOnly) {
            try {
                this.xaContainer.openLogicalLog();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to open lucene log in " + this.baseStorePath, e);
            }
            this.setLogicalLogAtCreationTime(this.xaContainer.getLogicalLog());
        }
    }

    private File logBaseName(File baseDirectory) {
        return new File(baseDirectory, "lucene.log");
    }

    private File baseDirectory(File storeDir) {
        return new File(storeDir, "index");
    }

    IndexType getType(IndexIdentifier identifier, boolean recovery) {
        return this.typeCache.getIndexType(identifier, recovery);
    }

    private IndexProviderStore newIndexStore(File dbStoreDir, FileSystemAbstraction fileSystem, boolean allowUpgrade) {
        File file = new File(dbStoreDir, "lucene-store.db");
        return new IndexProviderStore(file, fileSystem, INDEX_VERSION, allowUpgrade);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LuceneDataSource luceneDataSource = this;
        synchronized (luceneDataSource) {
            super.stop();
            if (this.closed) {
                return;
            }
            this.closed = true;
            for (IndexReference searcher : this.indexSearchers.values()) {
                try {
                    searcher.dispose(true);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.indexSearchers.clear();
        }
        if (this.xaContainer != null) {
            this.xaContainer.close();
        }
        this.providerStore.close();
    }

    public void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Index<Node> nodeIndex(String indexName, GraphDatabaseService graphDb, LuceneIndexImplementation luceneIndexImplementation) {
        IndexIdentifier identifier = new IndexIdentifier(1, this.nodeEntityType, indexName);
        Map<IndexIdentifier, LuceneIndex<? extends PropertyContainer>> map = this.indexes;
        synchronized (map) {
            LuceneIndex.NodeIndex index = this.indexes.get(identifier);
            if (index == null) {
                index = new LuceneIndex.NodeIndex(luceneIndexImplementation, graphDb, identifier, this.txManager);
                this.indexes.put(identifier, index);
            }
            return index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationshipIndex relationshipIndex(String indexName, GraphDatabaseService gdb, LuceneIndexImplementation luceneIndexImplementation) {
        IndexIdentifier identifier = new IndexIdentifier(2, this.relationshipEntityType, indexName);
        Map<IndexIdentifier, LuceneIndex<? extends PropertyContainer>> map = this.indexes;
        synchronized (map) {
            LuceneIndex.RelationshipIndex index = this.indexes.get(identifier);
            if (index == null) {
                index = new LuceneIndex.RelationshipIndex(luceneIndexImplementation, gdb, identifier, this.txManager);
                this.indexes.put(identifier, index);
            }
            return index;
        }
    }

    public XaConnection getXaConnection() {
        return new LuceneXaConnection(this.baseStorePath, this.xaContainer.getResourceManager(), this.getBranchId());
    }

    private synchronized IndexReference[] getAllIndexes() {
        Collection indexReferences = this.indexSearchers.values();
        return indexReferences.toArray(new IndexReference[indexReferences.size()]);
    }

    void getReadLock() {
        this.lock.readLock().lock();
    }

    void releaseReadLock() {
        this.lock.readLock().unlock();
    }

    void getWriteLock() {
        this.lock.writeLock().lock();
    }

    void releaseWriteLock() {
        this.lock.writeLock().unlock();
    }

    private IndexReference refreshSearcher(IndexReference searcher) {
        try {
            IndexReader reader = searcher.getSearcher().getIndexReader();
            IndexWriter writer = searcher.getWriter();
            IndexReader reopened = IndexReader.openIfChanged((IndexReader)reader, (IndexWriter)writer, (boolean)true);
            if (reopened != null) {
                IndexSearcher newSearcher = this.newIndexSearcher(searcher.getIdentifier(), reopened);
                searcher.detachOrClose();
                return new IndexReference(searcher.getIdentifier(), newSearcher, writer);
            }
            return searcher;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static File getFileDirectory(File storeDir, byte entityType) {
        File path = new File(storeDir, "lucene");
        String extra = null;
        if (entityType == 1) {
            extra = "node";
        } else if (entityType == 2) {
            extra = "relationship";
        } else {
            throw new RuntimeException("" + entityType);
        }
        return new File(path, extra);
    }

    static File getFileDirectory(File storeDir, IndexIdentifier identifier) {
        return new File(LuceneDataSource.getFileDirectory(storeDir, identifier.entityTypeByte), identifier.indexName);
    }

    static Directory getDirectory(File storeDir, IndexIdentifier identifier) throws IOException {
        return FSDirectory.open((File)LuceneDataSource.getFileDirectory(storeDir, identifier));
    }

    static TopFieldCollector scoringCollector(Sort sorting, int n) throws IOException {
        return TopFieldCollector.create((Sort)sorting, (int)n, (boolean)false, (boolean)true, (boolean)false, (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IndexReference getIndexSearcher(IndexIdentifier identifier) {
        this.assertNotClosed();
        IndexReference searcher = (IndexReference)this.indexSearchers.get(identifier);
        if (searcher == null) {
            return this.syncGetIndexSearcher(identifier);
        }
        IndexReference indexReference = searcher;
        synchronized (indexReference) {
            searcher = (IndexReference)this.indexSearchers.get(identifier);
            if (searcher == null || searcher.isClosed()) {
                return this.syncGetIndexSearcher(identifier);
            }
            searcher = this.refreshSearcherIfNeeded(searcher);
            searcher.incRef();
            return searcher;
        }
    }

    private void assertNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("Lucene index provider has been shut down");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized IndexReference syncGetIndexSearcher(IndexIdentifier identifier) {
        try {
            IndexReference searcher = (IndexReference)this.indexSearchers.get(identifier);
            if (searcher == null) {
                IndexWriter writer = this.newIndexWriter(identifier);
                IndexReader reader = IndexReader.open((IndexWriter)writer, (boolean)true);
                IndexSearcher indexSearcher = this.newIndexSearcher(identifier, reader);
                searcher = new IndexReference(identifier, indexSearcher, writer);
                this.indexSearchers.put(identifier, searcher);
            } else {
                IndexReference indexReference = searcher;
                synchronized (indexReference) {
                    searcher = this.refreshSearcherIfNeeded(searcher);
                }
            }
            searcher.incRef();
            return searcher;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private IndexSearcher newIndexSearcher(IndexIdentifier identifier, IndexReader reader) {
        IndexSearcher searcher = new IndexSearcher(reader);
        IndexType type = this.getType(identifier, false);
        if (type.getSimilarity() != null) {
            searcher.setSimilarity(type.getSimilarity());
        }
        return searcher;
    }

    private IndexReference refreshSearcherIfNeeded(IndexReference searcher) {
        if (searcher.checkAndClearStale() && (searcher = this.refreshSearcher(searcher)) != null) {
            this.indexSearchers.put(searcher.getIdentifier(), searcher);
        }
        return searcher;
    }

    XaTransaction createTransaction(XaLogicalLog logicalLog, TransactionState state) {
        return new LuceneTransaction(logicalLog, state, this);
    }

    void invalidateIndexSearcher(IndexIdentifier identifier) {
        IndexReference searcher = (IndexReference)this.indexSearchers.get(identifier);
        if (searcher != null) {
            searcher.setStale();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteIndex(IndexIdentifier identifier, boolean recovery) {
        boolean removeFromIndexStore;
        this.closeIndex(identifier);
        LuceneDataSource.deleteFileOrDirectory(LuceneDataSource.getFileDirectory(this.baseStorePath, identifier));
        this.invalidateCache(identifier);
        boolean bl = removeFromIndexStore = !recovery || recovery && this.indexStore.has(identifier.entityType.getType(), identifier.indexName);
        if (removeFromIndexStore) {
            this.indexStore.remove(identifier.entityType.getType(), identifier.indexName);
        }
        this.typeCache.invalidate(identifier);
        Map<IndexIdentifier, LuceneIndex<? extends PropertyContainer>> map = this.indexes;
        synchronized (map) {
            LuceneIndex<? extends PropertyContainer> index = this.indexes.remove(identifier);
            if (index != null) {
                index.markAsDeleted();
            }
        }
    }

    private static void deleteFileOrDirectory(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                for (File child : file.listFiles()) {
                    LuceneDataSource.deleteFileOrDirectory(child);
                }
            }
            file.delete();
        }
    }

    private IndexWriter newIndexWriter(IndexIdentifier identifier) {
        this.assertNotClosed();
        try {
            Directory dir = this.filesystemFacade.getDirectory(this.baseStorePath, identifier);
            this.directoryExists(dir);
            IndexType type = this.getType(identifier, false);
            IndexWriterConfig writerConfig = new IndexWriterConfig(LUCENE_VERSION, type.analyzer);
            writerConfig.setIndexDeletionPolicy((IndexDeletionPolicy)new MultipleBackupDeletionPolicy());
            Similarity similarity = type.getSimilarity();
            if (similarity != null) {
                writerConfig.setSimilarity(similarity);
            }
            IndexWriter indexWriter = new IndexWriter(dir, writerConfig);
            return indexWriter;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean directoryExists(Directory dir) {
        try {
            String[] files = dir.listAll();
            return files != null && files.length > 0;
        }
        catch (IOException e) {
            return false;
        }
    }

    static Document findDocument(IndexType type, IndexSearcher searcher, long entityId) {
        try {
            TopDocs docs = searcher.search(type.idTermQuery(entityId), 1);
            if (docs.scoreDocs.length > 0) {
                return searcher.doc(docs.scoreDocs[0].doc);
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static boolean documentIsEmpty(Document document) {
        List fields = document.getFields();
        for (Fieldable field : fields) {
            if ("_id_".equals(field.name()) || "_end_node_id_".equals(field.name()) || "_start_node_id_".equals(field.name())) continue;
            return false;
        }
        return true;
    }

    static void remove(IndexWriter writer, Query query) {
        try {
            writer.deleteDocuments(query);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to delete for " + query + " using" + writer, e);
        }
    }

    private synchronized void closeIndex(IndexIdentifier identifier) {
        try {
            IndexReference searcher = (IndexReference)this.indexSearchers.remove(identifier);
            if (searcher != null) {
                searcher.dispose(true);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to close lucene writer " + identifier, e);
        }
    }

    LruCache<String, Collection<Long>> getFromCache(IndexIdentifier identifier, String key) {
        return this.caching.get(identifier, key);
    }

    void setCacheCapacity(IndexIdentifier identifier, String key, int maxNumberOfCachedEntries) {
        this.caching.setCapacity(identifier, key, maxNumberOfCachedEntries);
    }

    Integer getCacheCapacity(IndexIdentifier identifier, String key) {
        LruCache<String, Collection<Long>> cache = this.caching.get(identifier, key);
        return cache != null ? Integer.valueOf(cache.maxSize()) : null;
    }

    void invalidateCache(IndexIdentifier identifier, String key, Object value) {
        LruCache<String, Collection<Long>> cache = this.caching.get(identifier, key);
        if (cache != null) {
            cache.remove((Object)value.toString());
        }
    }

    void invalidateCache(IndexIdentifier identifier) {
        this.caching.disable(identifier);
    }

    public long getCreationTime() {
        return this.providerStore.getCreationTime();
    }

    public long getRandomIdentifier() {
        return this.providerStore.getRandomNumber();
    }

    public long getCurrentLogVersion() {
        return this.providerStore.getVersion();
    }

    public long getLastCommittedTxId() {
        return this.providerStore.getLastCommittedTx();
    }

    public void setLastCommittedTxId(long txId) {
        this.providerStore.setLastCommittedTx(txId);
    }

    public XaContainer getXaContainer() {
        return this.xaContainer;
    }

    public ResourceIterator<File> listStoreFiles(boolean includeLogicalLogs) throws IOException {
        final ArrayList<File> files = new ArrayList<File>();
        final ArrayList<SnapshotDeletionPolicy> snapshots = new ArrayList<SnapshotDeletionPolicy>();
        this.makeSureAllIndexesAreInstantiated();
        for (IndexReference writer : this.getAllIndexes()) {
            SnapshotDeletionPolicy deletionPolicy = (SnapshotDeletionPolicy)writer.getWriter().getConfig().getIndexDeletionPolicy();
            File indexDirectory = LuceneDataSource.getFileDirectory(this.baseStorePath, writer.getIdentifier());
            try {
                IndexCommit commit = deletionPolicy.snapshot("backup");
                for (String fileName : commit.getFileNames()) {
                    files.add(new File(indexDirectory, fileName));
                }
                snapshots.add(deletionPolicy);
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
        files.add(this.providerStore.getFile());
        return new PrefetchingResourceIterator<File>(){
            private final Iterator<File> filesIterator;
            {
                this.filesIterator = files.iterator();
            }

            protected File fetchNextOrNull() {
                return this.filesIterator.hasNext() ? this.filesIterator.next() : null;
            }

            public void close() {
                for (SnapshotDeletionPolicy deletionPolicy : snapshots) {
                    try {
                        deletionPolicy.release("backup");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
    }

    public ResourceIterator<File> listStoreFiles() throws IOException {
        return this.listStoreFiles(false);
    }

    public ResourceIterator<File> listLogicalLogs() throws IOException {
        return IteratorUtil.emptyIterator();
    }

    public LogBufferFactory createLogBufferFactory() {
        return this.xaContainer.getLogicalLog().createLogWriter((Function)new Function<Config, File>(){

            public File apply(Config config) {
                return LuceneDataSource.this.logBaseName(LuceneDataSource.this.baseDirectory((File)config.get(GraphDatabaseSettings.store_dir)));
            }
        });
    }

    private void makeSureAllIndexesAreInstantiated() {
        IndexIdentifier identifier;
        Map config;
        for (String name : this.indexStore.getNames(Node.class)) {
            config = this.indexStore.get(Node.class, name);
            if (!((String)config.get("provider")).equals("lucene")) continue;
            identifier = new IndexIdentifier(1, this.nodeEntityType, name);
            this.getIndexSearcher(identifier);
        }
        for (String name : this.indexStore.getNames(Relationship.class)) {
            config = this.indexStore.get(Relationship.class, name);
            if (!((String)config.get("provider")).equals("lucene")) continue;
            identifier = new IndexIdentifier(2, this.relationshipEntityType, name);
            this.getIndexSearcher(identifier);
        }
    }

    void addExpectedFutureDeletion(IndexIdentifier identifier) {
        this.expectedFutureRecoveryDeletions.add(identifier);
    }

    void removeExpectedFutureDeletion(IndexIdentifier identifier) {
        this.expectedFutureRecoveryDeletions.remove(identifier);
    }

    private static enum LuceneFilesystemFacade {
        FS{

            @Override
            Directory getDirectory(File baseStorePath, IndexIdentifier identifier) throws IOException {
                return FSDirectory.open((File)LuceneDataSource.getFileDirectory(baseStorePath, identifier));
            }

            @Override
            void cleanWriteLocks(File dir) {
                if (!dir.isDirectory()) {
                    return;
                }
                for (File file : dir.listFiles()) {
                    if (file.isDirectory()) {
                        this.cleanWriteLocks(file);
                        continue;
                    }
                    if (!file.getName().equals("write.lock")) continue;
                    boolean success = file.delete();
                    assert (success);
                }
            }

            @Override
            File ensureDirectoryExists(FileSystemAbstraction fileSystem, File dir) {
                if (!dir.exists() && !dir.mkdirs()) {
                    String message = String.format("Unable to create directory path[%s] for Neo4j store.", dir.getAbsolutePath());
                    throw new RuntimeException(message);
                }
                return dir;
            }
        }
        ,
        MEMORY{

            @Override
            Directory getDirectory(File baseStorePath, IndexIdentifier identifier) {
                return new RAMDirectory();
            }

            @Override
            void cleanWriteLocks(File path) {
            }

            @Override
            File ensureDirectoryExists(FileSystemAbstraction fileSystem, File path) {
                try {
                    fileSystem.mkdirs(path);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return path;
            }
        };


        abstract Directory getDirectory(File var1, IndexIdentifier var2) throws IOException;

        abstract File ensureDirectoryExists(FileSystemAbstraction var1, File var2);

        abstract void cleanWriteLocks(File var1);
    }

    private class LuceneTransactionFactory
    extends XaTransactionFactory {
        private LuceneTransactionFactory() {
        }

        public XaTransaction create(long lastCommittedTxWhenTransactionStarted, TransactionState state) {
            return LuceneDataSource.this.createTransaction(this.getLogicalLog(), state);
        }

        public void flushAll() {
            for (IndexReference index : LuceneDataSource.this.getAllIndexes()) {
                try {
                    index.getWriter().commit();
                }
                catch (IOException e) {
                    throw new RuntimeException("unable to commit changes to " + index.getIdentifier(), e);
                }
            }
            LuceneDataSource.this.providerStore.flush();
        }

        public void recoveryComplete() {
            if (!LuceneDataSource.this.expectedFutureRecoveryDeletions.isEmpty()) {
                throw new TransactionFailureException("Recovery discovered transactions which couldn't be applied due to a future index deletion, however some expected deletions weren't encountered: " + LuceneDataSource.this.expectedFutureRecoveryDeletions);
            }
        }

        public long getCurrentVersion() {
            return LuceneDataSource.this.providerStore.getVersion();
        }

        public long getAndSetNewVersion() {
            return LuceneDataSource.this.providerStore.incrementVersion();
        }

        public void setVersion(long version) {
            LuceneDataSource.this.providerStore.setVersion(version);
        }

        public long getLastCommittedTx() {
            return LuceneDataSource.this.providerStore.getLastCommittedTx();
        }
    }

    private static class LuceneCommandWriterFactory
    implements XaCommandWriterFactory {
        private LuceneCommandWriterFactory() {
        }

        public XaCommandWriter newInstance() {
            return new XaCommandWriter(){

                public void write(XaCommand command, LogBuffer buffer) throws IOException {
                    ((LuceneCommand)command).writeToFile(buffer);
                }
            };
        }
    }

    public static class LuceneCommandReaderFactory
    implements XaCommandReaderFactory {
        private final EntityType nodeEntityType;
        private final EntityType relationshipEntityType;

        public LuceneCommandReaderFactory(EntityType nodeEntityType, EntityType relationshipEntityType) {
            this.nodeEntityType = nodeEntityType;
            this.relationshipEntityType = relationshipEntityType;
        }

        public XaCommandReader newInstance(byte logEntryVersion, final ByteBuffer scratch) {
            return new XaCommandReader(){

                public XaCommand read(ReadableByteChannel channel) throws IOException {
                    return LuceneCommand.readCommand(channel, scratch, LuceneCommandReaderFactory.this.nodeEntityType, LuceneCommandReaderFactory.this.relationshipEntityType);
                }
            };
        }
    }

    public static abstract class Configuration
    extends LogBackedXaDataSource.Configuration {
        public static final Setting<Integer> lucene_searcher_cache_size = GraphDatabaseSettings.lucene_searcher_cache_size;
        public static final Setting<Boolean> read_only = GraphDatabaseSettings.read_only;
        public static final Setting<Boolean> allow_store_upgrade = GraphDatabaseSettings.allow_store_upgrade;
        public static final Setting<Boolean> ephemeral = InternalAbstractGraphDatabase.Configuration.ephemeral;
        public static final Setting<File> store_dir = NeoStoreXaDataSource.Configuration.store_dir;
    }
}

