/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.systemgraph.versions;

import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.logging.Log;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.systemgraph.UserSecurityGraphComponentVersion;
import org.neo4j.server.security.systemgraph.versions.KnownCommunitySecurityComponentVersion;
import org.neo4j.server.security.systemgraph.versions.SupportedCommunitySecurityComponentVersion;

public class CommunitySecurityComponentVersion_4_50
extends SupportedCommunitySecurityComponentVersion {
    private final KnownCommunitySecurityComponentVersion previous;

    public CommunitySecurityComponentVersion_4_50(Log debugLog, AbstractSecurityLog securityLog, UserRepository userRepository, KnownCommunitySecurityComponentVersion previous) {
        super(UserSecurityGraphComponentVersion.COMMUNITY_SECURITY_50, userRepository, debugLog, securityLog);
        this.previous = previous;
    }

    @Override
    public void upgradeSecurityGraph(Transaction tx, int fromVersion) throws Exception {
        if (fromVersion < this.version) {
            this.previous.upgradeSecurityGraph(tx, fromVersion);
            this.setVersionProperty(tx, this.version);
        }
    }

    @Override
    public void upgradeSecurityGraphSchema(Transaction tx, int fromVersion) throws Exception {
        block3: {
            if (fromVersion < this.version) {
                this.previous.upgradeSecurityGraphSchema(tx, fromVersion);
                try {
                    tx.schema().constraintFor(USER_LABEL).assertPropertyIsUnique("id").create();
                }
                catch (ConstraintViolationException e) {
                    if (e.getMessage().startsWith("An equivalent constraint already exists")) break block3;
                    throw e;
                }
            }
        }
    }
}

