/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.neo4j.internal.helpers.Format;
import org.neo4j.storageengine.api.ExternalStoreId;
import org.neo4j.storageengine.api.StoreIdProvider;

public class StoreIdDecodeUtils {
    private static final String DEFAULT_ALGORITHM = "SHA-256";

    private StoreIdDecodeUtils() {
    }

    public static String decodeId(StoreIdProvider storeIdProvider) throws NoSuchAlgorithmException {
        return StoreIdDecodeUtils.decodeId(storeIdProvider.getExternalStoreId());
    }

    public static String decodeId(ExternalStoreId externalStoreId) throws NoSuchAlgorithmException {
        String storeIdString = externalStoreId.getId().toString();
        MessageDigest messageDigest = MessageDigest.getInstance(DEFAULT_ALGORITHM);
        messageDigest.update(storeIdString.getBytes());
        return Format.hexString((byte[])messageDigest.digest());
    }
}

